﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>
#include <nn/os.h>

#include <nn/nn_Common.h>

#include <nn/pwm/pwm.h>

#include <nn/fan/fan_ControlTypes.h>

namespace nn {
namespace fan {
namespace impl {
namespace detail {

class DeviceAccessor
{
    NN_DISALLOW_COPY(DeviceAccessor);
    NN_DISALLOW_MOVE(DeviceAccessor);

public:
    virtual int GetTargetRotationRate() const NN_NOEXCEPT
    {
        return m_RotationRate;
    }
    virtual int GetCurrentRotationRate() const NN_NOEXCEPT
    {
        return GetTargetRotationRate();
    }
    virtual void SetTargetRotationRate(int rotationRate) NN_NOEXCEPT
    {
        m_RotationRate = rotationRate;
    }
    virtual void SetFanEnabled(bool enabled) NN_NOEXCEPT
    {
        NN_UNUSED(enabled);
    }
    virtual void NotifyElapsedTime(int64_t elapsedTimeUsec) NN_NOEXCEPT
    {
        NN_UNUSED(elapsedTimeUsec);
    }
    virtual void SetFanEnabledFromServer(bool enabled) NN_NOEXCEPT
    {
        NN_UNUSED(enabled);
    };

protected:
    DeviceAccessor() NN_NOEXCEPT : m_RotationRate(0)
    {
    }

    int  m_RotationRate;
};

} // detail
} // impl
} // fan
} // nn
