﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/fan/impl/fan_Control.h>

#include "fan_ControllerResourceManager.h"
#include "fan_DeviceAccessor.h"

namespace nn {
namespace fan {
namespace impl {
namespace detail {

/**
 * @brief   セッションの実データ構造体
 */
class ControllerImpl
{
public:
    ControllerImpl(ControllerHolder* pControllerHolder, FanName name) NN_NOEXCEPT;

    ControllerHolder* GetControllerHolder() const NN_NOEXCEPT
    {
        return m_pControllerHolder;
    }

    int GetTargetRotationRate() const NN_NOEXCEPT
    {
        return m_pDeviceAccessor->GetTargetRotationRate();
    }

    int GetCurrentRotationRate() const NN_NOEXCEPT
    {
        return m_pDeviceAccessor->GetCurrentRotationRate();
    }

    void SetTargetRotationRate(int rotationRate) NN_NOEXCEPT
    {
        m_pDeviceAccessor->SetTargetRotationRate(rotationRate);
    }
    void SetFanEnabled(bool enabled) NN_NOEXCEPT
    {
        m_pDeviceAccessor->SetFanEnabled(enabled);
    }

private:
    ControllerHolder* m_pControllerHolder;
    DeviceAccessor* m_pDeviceAccessor;
};

struct ControllerImplPadded
{
    ControllerImpl  impl;

    // Controller 型の TypedStorage とサイズを合わせるための微調整部分
    char                _padding[ControllerSize - sizeof(ControllerImpl)];
};

NN_FORCEINLINE
ControllerImpl& ToControllerImpl(Controller& controller)
{
    return nn::util::Get<ControllerImplPadded>(controller._impl).impl;
}

NN_FORCEINLINE
const ControllerImpl& ToControllerImpl(const Controller& controller)
{
    return nn::util::Get<ControllerImplPadded>(controller._impl).impl;
}

} // detail
} // impl
} // fan
} // nn
