﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/psc.h>
#include <nn/erpt/erpt_Manager.h>

namespace nn    {
namespace eupld {
namespace srv   {

const uint32_t MaxRetryTimeMs     = (6  * 60 * 60 * 1000);
const uint32_t InitialRetryTimeMs = (30 * 1000);
const uint32_t WorkerStackSize    = (16 * 1024);

class Worker
{
private:
    static nn::psc::PmState   m_PmState;
    static bool               m_AutoUpload;
    static nn::TimeSpan       m_AutoUploadEndTime;
    static nn::os::TimerEvent m_TimerEvent;
    static bool               m_RetryUploadOnAwake;
    nn::os::SystemEvent       m_RequestEvent;
    nn::os::SystemEvent       m_PmEvent;
    nn::erpt::Manager         m_ReportManager;
    uint32_t                  m_RetryTimeMs;
    bool                      m_Running;
    nn::os::ThreadType        m_Thread;
    NN_ALIGNAS(4096) uint8_t  m_Stack[WorkerStackSize];
    nn::psc::PmModule         m_Module;

    void UpdateBackOffTimer(nn::Result result)
    NN_NOEXCEPT;

public:
    void HandleNewReport()
    NN_NOEXCEPT;

    nn::Result HandleNewRequest()
    NN_NOEXCEPT;

    void SignalNewRequest()
    NN_NOEXCEPT;

    void Loop()
    NN_NOEXCEPT;

    nn::Result Start()
    NN_NOEXCEPT;

    void Stop()
    NN_NOEXCEPT;

    static void ThreadEntry(void* arg)
    NN_NOEXCEPT;

    static nn::Result SetAutoUpload(bool enable, uint32_t flagValidTimeSeconds)
    NN_NOEXCEPT;

    static nn::Result GetAutoUpload(bool* pOutIsEnabled, uint32_t* pOutFlagValidTimeSeconds)
    NN_NOEXCEPT;

    void HandlePmEvents()
    NN_NOEXCEPT;

    Worker()
    NN_NOEXCEPT;

    ~Worker()
    NN_NOEXCEPT;
};

extern Worker g_Worker;

}}}
