﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/eupld/sfdl/eupld.sfdl.h>

namespace nn    {
namespace eupld {
namespace srv   {

class IControl :
    public nn::sf::ISharedObject
{
public:
    nn::Result SetUrl(nn::sf::InBuffer urlString)
    NN_NOEXCEPT;

    nn::Result ImportCrt(nn::sf::InBuffer crt)
    NN_NOEXCEPT;

    nn::Result ImportPki(nn::sf::InBuffer pki, nn::sf::InBuffer password)
    NN_NOEXCEPT;

    nn::Result SetAutoUpload(bool enable, uint32_t flagValidTimeSeconds)
    NN_NOEXCEPT;

    nn::Result GetAutoUpload(nn::sf::Out<bool> pOutAudoUpload, nn::sf::Out<std::uint32_t> pOutFlagValidTimeSeconds)
    NN_NOEXCEPT;
};

}}}
