﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/eupld/eupld_Result.h>

#include "eupldsrv_IControl.h"
#include "eupldsrv_Transport.h"
#include "eupldsrv_Worker.h"

namespace nn    {
namespace eupld {
namespace srv   {

nn::Result IControl::SetUrl(nn::sf::InBuffer urlString)
NN_NOEXCEPT
{
    return Transport::SetUrl(urlString.GetPointerUnsafe(), static_cast<uint32_t>(urlString.GetSize()));
}

nn::Result IControl::ImportCrt(nn::sf::InBuffer crt)
NN_NOEXCEPT
{
    NN_UNUSED(crt);
    return ResultSuccess();
}

nn::Result IControl::ImportPki(nn::sf::InBuffer pki, nn::sf::InBuffer password)
NN_NOEXCEPT
{
    NN_UNUSED(pki);
    NN_UNUSED(password);
    return ResultSuccess();
}

nn::Result IControl::SetAutoUpload(bool enable, uint32_t flagValidTimeSeconds)
NN_NOEXCEPT
{
    return Worker::SetAutoUpload(enable, flagValidTimeSeconds);
}

nn::Result IControl::GetAutoUpload(nn::sf::Out<bool> pOutAudoUpload, nn::sf::Out<std::uint32_t> pOutFlagValidTimeSeconds)
NN_NOEXCEPT
{
    return Worker::GetAutoUpload(pOutAudoUpload.GetPointer(), pOutFlagValidTimeSeconds.GetPointer());
}

}}}
