﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Result.h>
#include <nn/lmem/lmem_Common.h>
#include <nn/lmem/lmem_ExpHeap.h>

namespace nn    {
namespace eupld {
namespace srv   {

extern lmem::HeapHandle g_HeapHandle;

class Allocator
{
public:
    void* operator new(size_t size)
    NN_NOEXCEPT
    {
        void* p = lmem::AllocateFromExpHeap(g_HeapHandle, size);
        return p;
    }

    void* operator new(size_t size, size_t align)
    NN_NOEXCEPT
    {
        void* p = lmem::AllocateFromExpHeap(g_HeapHandle, size, static_cast<int>(align));
        return p;
    }

    void* operator new[](size_t size)
    NN_NOEXCEPT
    {
        void* p = lmem::AllocateFromExpHeap(g_HeapHandle, size);
        return p;
    }

    void* operator new[](std::size_t size, std::size_t align)
    NN_NOEXCEPT
    {
        void* p = lmem::AllocateFromExpHeap(g_HeapHandle, size, static_cast<int>(align));
        return p;
    }

    void operator delete(void* p)
    NN_NOEXCEPT
    {
        lmem::FreeToExpHeap(g_HeapHandle, p);
    }

    void operator delete[](void* p)
    NN_NOEXCEPT
    {
        lmem::FreeToExpHeap(g_HeapHandle, p);
    }
};

}}}
