﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.es
{
    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(8, 8)]
    public struct TicketId { }

    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(8, 8)]
    public struct DeviceId { }

    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(8, 8)]
    public struct RightsId { }

    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(8, 8)]
    public struct KeyId { }

    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(16, 1)]
    public struct RightsIdIncludingKeyId { }

    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct AccountId { }

    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(2, 2)]
    public struct TicketVersion { }

    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(16, 1)]
    [LargeData(true)]
    public struct AesKey { }

    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(256, 1)]
    [LargeData(true)]
    public struct RsaKey { }

    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(60, 1)]
    [LargeData(true)]
    public struct Sign { }

    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(384, 1)]
    [LargeData(true)]
    public struct Certificate { }

    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(260, 4)]
    [LargeData(true)]
    public struct TitleKey { }

    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(64, 8)]
    [LargeData(true)]
    public struct TicketInfo { }

    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(32, 8)]
    [LargeData(true)]
    public struct LightTicketInfo { }

    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(64, 8)]
    [LargeData(true)]
    public struct PrepurchaseRecord { }

    [CppRefPath(@"<nn/es/es_ELicenseTypes.h>")]
    [ExternalStruct(16, 1)]
    public struct ELicenseId { }

    [CppRefPath(@"<nn/es/es_ELicenseTypes.h>")]
    [ExternalStruct(16, 1)]
    public struct ELicenseArchiveId { }

    [CppRefPath(@"<nn/es/es_ELicenseTypes.h>")]
    [ExternalStruct(72, 8)]
    public struct ELicenseInfoWrapper { }

    [CppRefPath(@"<nn/es/es_ELicenseTypesForInner.h>")]
    [ExternalStruct(80, 8)]
    public struct ELicenseInfoForSystemWrapper { }

    [CppRefPath(@"<nn/es/es_ELicenseApi.h>")]
    [ExternalStruct(16, 8)]
    public struct ELicenseImportContext { }

    [CppRefPath(@"<nn/es/es_RightsTypes.h>")]
    [ExternalStruct(40, 8)]
    public struct Rights { }

    [CppRefPath(@"<nn/es/es_RightsTypes.h>")]
    [ExternalStruct(56, 8)]
    public struct RightsStatus { }

    [CppRefPath(@"<nn/es/es_TypesForInner.h>")]
    [ExternalStruct(8, 8)]
    public struct ELicenseOwnerId { }

    [CppRefPath(@"<nn/es/es_TypesForInner.h>")]
    [ExternalStruct(8, 8)]
    public struct ELicenseUserId { }

    [CppRefPath(@"<nn/es/es_LocalConcurrencyCheckTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct LocalConcurrencyCheckChallenge { }

    [CppRefPath(@"<nn/es/es_LocalConcurrencyCheckTypes.h>")]
    [ExternalStruct(768, 1)]
    [LargeData(true)]
    public struct LocalConcurrencyCheckData { }

    [CppRefPath(@"<nn/es/es_LocalConcurrencyCheckTypes.h>")]
    [ExternalStruct(256, 1)]
    [LargeData(true)]
    public struct LocalConcurrencyCheckAuthenticationInfo { }

    public interface IETicketService : IServiceObject
    {
        // es_Api.h
        [MethodId(1)]
        Result ImportTicket(InBuffer ticket, InBuffer certificate);

        [MethodId(2)]
        Result ImportTicketCertificateSet(InBuffer ticketCertificateSet);

        [MethodId(3)]
        Result DeleteTicket([BufferTransferMode(BufferTransferMode.MapAlias)] InArray<RightsIdIncludingKeyId> rightsIdList);

        [MethodId(4)]
        Result DeletePersonalizedTicket(AccountId accountId);

        [MethodId(5)]
        Result DeleteAllCommonTicket();

        [MethodId(6)]
        Result DeleteAllPersonalizedTicket();

        [MethodId(7)]
        Result DeleteAllPersonalizedTicketExcludingList([BufferTransferMode(BufferTransferMode.MapAlias)] InArray<TicketId> ticketIdExclusionList);

        //[MethodId(8)]
        //Result GetTitleKey([BufferTransferMode(BufferTransferMode.MapAlias)] Out<AesKey> pOutEncryptedTitleKey, RightsIdIncludingKeyId rightsId, int keyGeneration);

        [MethodId(9)]
        Result CountCommonTicket(Out<int> pOutCount);

        [MethodId(10)]
        Result CountPersonalizedTicket(Out<int> pOutCount);

        [MethodId(11)]
        Result ListCommonTicket(Out<int> pOutCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<RightsIdIncludingKeyId> outRightsIdList);

        [MethodId(12)]
        Result ListPersonalizedTicket(Out<int> pOutCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<RightsIdIncludingKeyId> outRightsIdList);

        [MethodId(13)]
        Result ListMissingPersonalizedTicket(Out<int> pOutCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<TicketId> outTicketIdList, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<TicketId> ticketIdList);

        [MethodId(14)]
        Result GetCommonTicketSize(Out<uint64_t> pOutSize, RightsIdIncludingKeyId rightsId);

        //[MethodId(15)]
        //Result GetPersonalizedTicketSize(Out<uint64_t> pOutSize, RightsIdIncludingKeyId rightsId);

        [MethodId(16)]
        Result GetCommonTicketData(Out<uint64_t> pOutSize, OutBuffer pOutBuffer, RightsIdIncludingKeyId rightsId);

        //[MethodId(17)]
        //Result GetPersonalizedTicketData(Out<uint64_t> pOutSize, OutBuffer pOutBuffer, RightsIdIncludingKeyId rightsId);

        [MethodId(18)]
        Result OwnTicket([BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<bool> outOwnTicketList, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<RightsIdIncludingKeyId> rightsIdList);

        [MethodId(19)]
        Result GetTicketInfo(Out<int> pOutCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<TicketInfo> outTicketInfoList, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<RightsIdIncludingKeyId> rightsIdList);

        [MethodId(20)]
        Result ListLightTicketInfo(Out<int> pOutCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<LightTicketInfo> outTicketInfoList, RightsIdIncludingKeyId rightsId);

        [MethodId(21)]
        Result SignData([BufferTransferMode(BufferTransferMode.MapAlias)] Out<Sign> pOutSign, [BufferTransferMode(BufferTransferMode.MapAlias)] Out<Certificate> pOutCertificate, InBuffer pData);

        [MethodId(22)]
        Result GetCommonTicketAndCertificateSize(Out<uint64_t> pOutTicketSize, Out<uint64_t> pOutCertificateSize, RightsIdIncludingKeyId rightsId);

        [MethodId(23)]
        Result GetCommonTicketAndCertificateData(Out<uint64_t> pOutTicketSize, Out<uint64_t> pOutCertificateSize, OutBuffer pOutTicketBuffer, OutBuffer pOutCertificateBuffer, RightsIdIncludingKeyId rightsId);

        [MethodId(24)]
        Result ImportPrepurchaseRecord([BufferTransferMode(BufferTransferMode.MapAlias)] PrepurchaseRecord record);

        [MethodId(25)]
        Result DeletePrepurchaseRecord([BufferTransferMode(BufferTransferMode.MapAlias)] PrepurchaseRecord record);

        [MethodId(26)]
        Result DeleteAllPrepurchaseRecord();

        [MethodId(27)]
        Result CountPrepurchaseRecord(Out<int> pOutCount);

        [MethodId(28)]
        Result ListPrepurchaseRecord(Out<int> pOutCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<RightsIdIncludingKeyId> outRightsIdList);

        [MethodId(29)]
        Result ListPrepurchaseRecordInfo(Out<int> pOutCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<PrepurchaseRecord> outPrepurchaseRecordList, RightsIdIncludingKeyId rightsId);

        [MethodId(30)]
        Result CountDesignatedTicket(Out<int> pOutCount, RightsId rightsId);

        [MethodId(31)]
        Result ListDesignatedTicket(Out<int> pOutCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<RightsIdIncludingKeyId> outRightsIdList, RightsId rightsId);

        [MethodId(32)]
        Result CountDesignatedPrepurchaseRecord(Out<int> pOutCount, RightsId rightsId);

        [MethodId(33)]
        Result ListDesignatedPrepurchaseRecord(Out<int> pOutCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<RightsIdIncludingKeyId> outRightsIdList, RightsId rightsId);

        [MethodId(34)]
        Result GetEncryptedTicketSize(Out<uint64_t> pOutSize, RightsIdIncludingKeyId rightsId);

        [MethodId(35)]
        Result GetEncryptedTicketData(Out<uint64_t> pOutTicketId, Out<uint64_t> pOutSize, OutBuffer pOutBuffer, OutBuffer pOutKey, RightsIdIncludingKeyId rightsId);

        // es_RightsApi.h
        [MethodId(501)]
        Result CheckRightsStatusIncludingKeyId([BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<RightsStatus> outStatusList, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<RightsIdIncludingKeyId> rightsIdList, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ELicenseUserId> userIdList, bool onlyAllAccountRights);

        [MethodId(502)]
        Result CheckRightsStatus([BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<RightsStatus> outStatusList, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<RightsId> rightsIdList, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ELicenseUserId> userIdList, bool onlyAllAccountRights);

        [MethodId(503)]
        Result RegisterTitleKey([BufferTransferMode(BufferTransferMode.MapAlias)] InArray<RightsIdIncludingKeyId> rightsIdList, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<int> keyGenerationList);

        [MethodId(504)]
        Result UnregisterAllTitleKey();

        [MethodId(506)]
        Result RegisterAccountRestrictedRightsUser(ELicenseUserId userId);

        [MethodId(507)]
        Result UnregisterAllAccountRestrictedRightsUser();

        [MethodId(508)]
        Result ListAccountRestrictedRightsUser(Out<bool> outHasAccount, Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ELicenseUserId> outUserIdList);

        // es_ELicenseApi.h
        [MethodId(1001)]
        Result BeginImportELicenseArchive(Out<ELicenseImportContext> pOutContext, ELicenseOwnerId ownerId);

        [MethodId(1002)]
        Result ImportELicenseArchive(ELicenseImportContext context, InBuffer eLicenseArchive);

        [MethodId(1003)]
        Result EndImportELicenseArchive(Out<ELicenseArchiveId> pOutELicenseArchiveId, ELicenseImportContext context);

        [MethodId(1004)]
        Result CountELicense(Out<int> pOutCount);

        [MethodId(1005)]
        Result ListELicenseIds(Out<int> pOutCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ELicenseId> outELicenseIdList);

        [MethodId(1006)]
        Result ListELicenseInfo(Out<int> pOutCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ELicenseInfoWrapper> outELicenseInfoList, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ELicenseId> eLicenseIdList);

        [MethodId(1007)]
        Result ListELicenseInfoForDebug(Out<int> pOutCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ELicenseInfoForSystemWrapper> outELicenseInfoList, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ELicenseId> eLicenseIdList);

        [MethodId(1008)]
        Result EndImportELicenseArchiveForDebug(Out<ELicenseArchiveId> pOutELicenseArchiveId, ELicenseImportContext context);

        [MethodId(1009)]
        Result GetELicenseArchiveSizeForDebug(Out<uint64_t> pOutSize, ELicenseOwnerId ownerId);

        [MethodId(1010)]
        Result GetELicenseArchiveDataForDebug(Out<uint64_t> pOutSize, OutBuffer pOutBuffer, ELicenseOwnerId ownerId);

        [MethodId(1011)]
        Result DeleteAllELicenseArchiveForDebug();

        // es_LocalConcurrencyCheckApi.h
        [MethodId(1501)]
        Result GetChallengeOfLocalConcurrencyCheck(Out<LocalConcurrencyCheckChallenge> outValue);

        [MethodId(1502)]
        Result AuthorizeLocalConcurrencyCheckData([BufferTransferMode(BufferTransferMode.MapAlias)] Out<LocalConcurrencyCheckAuthenticationInfo> outInfo, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<LocalConcurrencyCheckData> authenticatedDataList, [BufferTransferMode(BufferTransferMode.MapAlias)] LocalConcurrencyCheckData unauthenticatedData);

        [MethodId(1503)]
        Result GetLocalConcurrencyCheckData([BufferTransferMode(BufferTransferMode.MapAlias)] Out<LocalConcurrencyCheckData> outData, LocalConcurrencyCheckChallenge challenge);

        [MethodId(1504)]
        Result VerifyLocalConcurrencyAuthentication([BufferTransferMode(BufferTransferMode.MapAlias)] LocalConcurrencyCheckAuthenticationInfo info);

        // es_ActiveRightsContext.h
        // 権利コンテキストのインスタンスを生成する
        [MethodId(2000)]
        Result CreateActiveRightsContext(Out<IActiveRightsContext> pOut);
    }
}
