﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.erpt
{
    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/erpt/erpt_Types.h>")]
    public struct ReportFlagSet
    {
    }

    [ExternalStruct(20, 4)]
    [CppRefPath(@"<nn/erpt/erpt_Types.h>")]
    public struct ReportId
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/erpt/erpt_Types.h>")]
    public struct ReportType
    {
    }

    [LargeData(true)]
    [ExternalStruct(1224, 8)]
    [CppRefPath(@"<nn/erpt/erpt_MultipleCategoryContext.h>")]
    public struct MultipleCategoryContextEntry
    {
    }

    [ExternalStruct(56, 8)]
    [CppRefPath(@"<nn/erpt/erpt_Types.h>")]
    public struct StorageUsageStatistics
    {
    }
}

namespace nn.time
{
    [ExternalStruct(24, 8)]
    [CppRefPath(@"<nn/time/time_SteadyClockTimePoint.h>")]
    public struct SteadyClockTimePoint
    {
    }
}

namespace nn.erpt.sf
{
    [CppRefPath(@"<nn/erpt/sfdl/erpt.sfdl.h>")]
    public interface ISession : IServiceObject
    {
        [MethodId(0)]
        Result OpenReport(Out<IReport> reportHandleOut);

        [MethodId(1)]
        Result OpenManager(Out<IManager> managerHandleOut);
    }

    [CppRefPath(@"<nn/erpt/sfdl/erpt.sfdl.h>")]
    public interface IManager : IServiceObject
    {
        [MethodId(0)]
        Result GetReportList(nn.sf.OutBuffer listBufferOut, ReportType filter);

        [MethodId(1)]
        Result GetEvent(Out<NativeHandle> eventHandleOut);

        [MethodId(2)]
        Result CleanupReports();

        [MethodId(3)]
        Result DeleteReport(ReportId reportId);

        [MethodId(4)]
        Result GetStorageUsageStatistics(Out<StorageUsageStatistics> outUsage);
    }

    [CppRefPath(@"<nn/erpt/sfdl/erpt.sfdl.h>")]
    public interface IReport : IServiceObject
    {
        [MethodId(0)]
        Result Open(ReportId reportId);

        [MethodId(1)]
        Result Read(Out<uint32_t> readCountOut, nn.sf.OutBuffer readBufferOut);

        [MethodId(2)]
        Result SetFlags(ReportFlagSet flagsIn);

        [MethodId(3)]
        Result GetFlags(Out<ReportFlagSet> flagsOut);

        [MethodId(4)]
        Result Close();

        [MethodId(5)]
        Result GetSize(Out<int64_t> sizeOut);
    }

    [CppRefPath(@"<nn/erpt/sfdl/erpt.sfdl.h>")]
    public interface IContext : IServiceObject
    {
        [MethodId(0)]
        Result SubmitContext(nn.sf.InBuffer contextBufferIn, nn.sf.InBuffer stringsBufferIn);

        [MethodId(1)]
        Result CreateReport(ReportType type, nn.sf.InBuffer contextBufferIn, nn.sf.InBuffer stringsBufferIn, nn.sf.InBuffer metaBufferIn);

        [MethodId(2)]
        Result SetInitialLaunchSettingsCompletionTime(nn.time.SteadyClockTimePoint timePoint);

        [MethodId(3)]
        Result ClearInitialLaunchSettingsCompletionTime();

        [MethodId(4)]
        Result UpdatePowerOnTime();

        [MethodId(5)]
        Result UpdateAwakeTime();

        [MethodId(6)]
        Result SubmitMultipleCategoryContext([BufferTransferMode(BufferTransferMode.MapAlias)] MultipleCategoryContextEntry contextEntryIn, nn.sf.InBuffer stringsBufferIn);
    }
}
