﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/erpt/server/erpt_ServerTypes.h>
#include <nn/util/util_IntrusiveList.h>

#include "erptsrv_Allocator.h"
#include "erptsrv_RefCount.h"

namespace nn   {
namespace erpt {
namespace srv  {

class JournalRecord :
    public Allocator,
    public RefCount,
    public nn::util::IntrusiveListBaseNode<JournalRecord>
{
public:
    ReportInfo m_Info;

    JournalRecord()
    NN_NOEXCEPT
    {
        std::memset(&m_Info, 0x0, sizeof(m_Info));
    }

    explicit JournalRecord(ReportInfo info)
    NN_NOEXCEPT :
        m_Info(info)
    {

    }
};

}}}
