﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <memory>
#include <nn/http/json/http_RapidJsonInputStream.h>

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace ec { namespace json {

class MemoryInputStreamBaseForRapidJson
    : public nn::http::json::StringBufferForRapidJson
{
public:
    typedef char Ch;
private:
    typedef nn::http::json::StringBufferForRapidJson StringBuffer;
    Ch* m_Buffer;
protected:
    Ch* GetBufferAddress() NN_NOEXCEPT
    {
        return m_Buffer;
    }
    MemoryInputStreamBaseForRapidJson(Ch* buffer, size_t bufferSize) NN_NOEXCEPT
        : m_Buffer(buffer)
    {
        NN_ABORT_UNLESS(buffer != nullptr);
        SetStringBuffer(buffer, bufferSize);
    }
};

class MemoryInputStreamForRapidJson
    : public MemoryInputStreamBaseForRapidJson
{
public:
    typedef char Ch;

private:
    const char* m_Ptr;
    size_t m_Bytes;
    size_t m_Pos;

public:
    MemoryInputStreamForRapidJson(void* buffer, size_t bufferSize) NN_NOEXCEPT
        : MemoryInputStreamBaseForRapidJson(reinterpret_cast<Ch*>(buffer), bufferSize)
        , m_Ptr(nullptr)
        , m_Bytes(0u)
        , m_Pos(0u)
    {
    }
    virtual ~MemoryInputStreamForRapidJson() NN_NOEXCEPT
    {
    }
    void Set(const char* ptr, size_t bytes) NN_NOEXCEPT
    {
        m_Ptr = ptr;
        m_Bytes = bytes;
    }
    Ch Peek() const NN_NOEXCEPT
    {
        return m_Pos == m_Bytes? '\0': m_Ptr[m_Pos];
    }
    Ch Take() NN_NOEXCEPT
    {
        auto c = Peek();
        if (c != '\0')
        {
            ++ m_Pos;
        }
        return c;
    }
    size_t Tell() const NN_NOEXCEPT
    {
        return m_Pos;
    }
    nn::Result GetResult() const NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }
};

}}} //! namespace nn::ec::json
