﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ec/ec_ShopApi.h>
#include <nn/ec/ec_ShopApiForSystem.h>
#include <nn/ec/detail/ec_ShopApiInternal.h>

#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace ec {

void LaunchEShop(const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT
{
    detail::LaunchEShopImpl(detail::LaunchMode_Full, uid, sourceId);
}

void ShowShopApplicationInformationForMenu(nn::ApplicationId applicationId, const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationId != nn::ApplicationId::GetInvalidId(),
        "'applicationId' must be valid");

    detail::ShowShopApplicationInformationImpl(detail::LaunchMode_Full, applicationId, uid, sourceId, nullptr);
}

void ShowShopApplicationInformationForMenu(NsUid nsuidApplication, const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(nsuidApplication != NsUid::GetInvalidId(),
        "'nsuidApplication' must be valid");

    detail::ShowShopApplicationInformationImpl(detail::LaunchMode_Full, nsuidApplication, uid, sourceId, nullptr);
}

void ShowShopApplicationInformationForMenu(nn::ApplicationId applicationId,
    const nn::account::Uid& uid, SourceId sourceId, const char* newsId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationId != nn::ApplicationId::GetInvalidId(),
        "'applicationId' must be valid");

    detail::ShowShopApplicationInformationImpl(detail::LaunchMode_Full, applicationId, uid, sourceId, newsId);
}

void ShowShopApplicationInformationForMenu(NsUid nsuidApplication,
    const nn::account::Uid& uid, SourceId sourceId, const char* newsId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(nsuidApplication != NsUid::GetInvalidId(),
        "'nsuidApplication' must be valid");

    detail::ShowShopApplicationInformationImpl(detail::LaunchMode_Full, nsuidApplication, uid, sourceId, newsId);
}

void ShowShopAddOnContentListForMenu(nn::ApplicationId applicationIdParent, const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationIdParent != nn::ApplicationId::GetInvalidId(),
        "'applicationIdParent' must be valid");

    detail::ShowShopAddOnContentListImpl(detail::LaunchMode_Full, applicationIdParent, uid, sourceId);
}

void ShowShopAddOnContentDetailsForMenu(NsUid nsuidAddOnContentItem, const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(nsuidAddOnContentItem != NsUid::GetInvalidId(),
        "'nsuidAddOnContentItem' must be valid");

    detail::ShowShopAddOnContentDetailsImpl(detail::LaunchMode_Full, nsuidAddOnContentItem, uid, sourceId);
}

void ShowShopCouponForMenu(CouponId couponId, const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT
{
    detail::ShowShopCouponImpl(detail::LaunchMode_Full, couponId, uid, sourceId);
}

void ShowShopInformationWithParams(const char* params, const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT
{
    NN_ABORT_UNLESS(params != nullptr && *params != 0,
        "Unexcepted: 'params' must not be an empty string");

    detail::ShowShopInformationWithParamsImpl(detail::LaunchMode_Full, params, uid, sourceId);
}

void ShowShopApplicationInformationForMenu(nn::ApplicationId applicationId,
    const nn::account::Uid& uid, bool isUnsearchableAllowed, SourceId sourceId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationId != nn::ApplicationId::GetInvalidId(),
        "'applicationId' must be valid");

    if (isUnsearchableAllowed)
    {
        detail::ShowShopSecretApplicationInformationImpl(detail::LaunchMode_Full, applicationId, uid, sourceId);
    }
    else
    {
        detail::ShowShopApplicationInformationImpl(detail::LaunchMode_Full, applicationId, uid, sourceId, nullptr);
    }
}

void ShowShopApplicationInformationForMenu(NsUid nsuidApplication,
    const nn::account::Uid& uid, bool isUnsearchableAllowed, SourceId sourceId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(nsuidApplication != NsUid::GetInvalidId(),
        "'nsuidTitle' must be valid");

    if (isUnsearchableAllowed)
    {
        detail::ShowShopSecretApplicationInformationImpl(detail::LaunchMode_Full, nsuidApplication, uid, sourceId);
    }
    else
    {
        detail::ShowShopApplicationInformationImpl(detail::LaunchMode_Full, nsuidApplication, uid, sourceId, nullptr);
    }
}

void ShowShopSettingsForMenu(const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(uid != nn::account::InvalidUid,
        "Valid 'uid' is necessary for this function");

    detail::ShowShopSettingsImpl(detail::LaunchMode_Full, uid, sourceId);
}

nn::Result ShowShopMembershipServiceInformation(const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(uid != nn::account::InvalidUid,
        "Valid 'uid' is necessary for this function");

    return detail::ShowShopMembershipServiceInformationImpl(uid, sourceId);
}

nn::Result GetShopResultFromStorage(const nn::applet::StorageHandle& handle) NN_NOEXCEPT
{
    return detail::GetShopResultFromStorageImpl(handle);
}

void ShowShopApplicationInformationForApplet(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationId != nn::ncm::ApplicationId::GetInvalidId());

    nn::ApplicationId id = {applicationId.value};
    detail::ShowShopApplicationInformationImpl(detail::LaunchMode_Mini, id, nn::account::InvalidUid, SourceId_Default, nullptr);
}

void ShowShopPreinstallInformationForMenu(const nn::account::Uid& uid, SourceId sourceId) NN_NOEXCEPT
{
    detail::ShowShopPreinstallInformationImpl(detail::LaunchMode_Full, uid, sourceId);
}

}}
