﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief クライアントにおける消費型サービスアイテムの権利の型を定義します（非公開）
 */

#pragma once
#include <nn/time/time_PosixTime.h>
#include <nn/ec/ec_ConsumableServiceItemTypes.h>

namespace nn { namespace ec {

//! 最新のセーブデータバージョン
const int ConsumableServiceItemLatestSaveDataVersion = 1;

/**
    @brief 権利情報の内容を一意に示す ID です。最大 36 文字の文字列として保持します
*/
struct ConsumableServiceItemRightId
{
    static const int Length = 36;
    char value[Length + 1];
};

/**
    @brief 権利消費を識別するための ID です。最大 36 文字の文字列として保持します。
*/
struct ConsumableServiceItemConsumptionRequestId
{
    static const int Length = 36;
    char value[Length + 1];
};

/**
    @brief サーバー上での権利の状態を示します
*/
enum ConsumableServiceItemServerRightStatus : int8_t
{
    ConsumableServiceItemServerRightStatus_Purchased,   //! 権利を購入済みです。権利消費を実行すると成功します。
    ConsumableServiceItemServerRightStatus_Consumed     //! 権利が消費済みです。権利消費を実行するとエラーが返ります。権利参照時には ConsumableServiceItemRightData 指定で参照してください。
};

/**
    @brief 消費型サービスアイテムの権利情報を表す構造体です。
*/
struct ConsumableServiceItemRightDataImpl
{
    ConsumableServiceItemRightId rightId;                           //! size = 37, alignment = 1
    ConsumableServiceItemId itemId;                                 //! size = 17, alignment = 1
    ConsumableServiceItemServerRightStatus status;                  //! size = 1,  alignment = 1
    bool isServiceProvidableOnLocal;                                //! size = 1,  alignment = 1
    nn::time::PosixTime purchasedPosixTime;                         //! size = 8,  alignment = 8
    ConsumableServiceItemConsumptionRequestId consumptionRequestId; //! size = 37, alignment = 1
    NN_PADDING3;
};

}}
