﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/dns/parser.h>
#include "dns_ParserMacros.h"

extern "C"
{
#include <nnc/dns/parser.h>

void nndnsparserRecordInitialize(struct nndnsparserRecord* pRecord,
                                 const struct nndnsparserMessage* pMessage)
{
    NN_DNSPARSER_ERROR_IF(nullptr == pRecord, bail);

    {
        auto object = reinterpret_cast<nn::dns::parser::Record*>(pRecord);
        auto m = reinterpret_cast<const nn::dns::parser::Message*>(pMessage);
        object->Initialize(m);
    };

bail:
    return;
};

ssize_t nndnsparserRecordSizeOf(const struct nndnsparserRecord* pRecord)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pRecord, bail);

    {
        auto object = reinterpret_cast<const nn::dns::parser::Record*>(pRecord);
        rc = object->SizeOf();
    };

bail:
    return rc;
};

bool nndnsparserRecordIsEqual(const struct nndnsparserRecord* pRecord1,
                              const struct nndnsparserRecord* pRecord2)
{
    bool rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pRecord1, bail);
    NN_DNSPARSER_ERROR_IF(nullptr == pRecord2, bail);

    {
        auto p = reinterpret_cast<const nn::dns::parser::Record*>(pRecord1);
        auto q = reinterpret_cast<const nn::dns::parser::Record*>(pRecord2);
        rc = (*p) == (*q);
    };

bail:
    return rc;
};

ssize_t nndnsparserRecordFromBuffer(struct nndnsparserRecord* pRecord,
                                    const uint8_t* pBuffer,
                                    size_t size)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pRecord, bail);

    {
        auto object = reinterpret_cast<nn::dns::parser::Record*>(pRecord);
        rc = object->FromBuffer(pBuffer, size);
    };

bail:
    return rc;
};

ssize_t nndnsparserRecordToBuffer(uint8_t * const pBuffer,
                                  size_t size,
                                  const struct nndnsparserRecord* pRecord)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pRecord, bail);

    {
        auto object = reinterpret_cast<const nn::dns::parser::Record*>(pRecord);
        rc = object->ToBuffer(pBuffer, size);
    };

bail:
    return rc;
};

}; // extern "C"
