﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/dns/parser.h>
#include "dns_ParserMacros.h"

extern "C"
{
#include <nnc/dns/parser.h>

void nndnsparserQuestionInitialize(struct nndnsparserQuestion* pQuestion,
                                   const struct nndnsparserMessage* pMessage)
{
    NN_DNSPARSER_ERROR_IF(nullptr == pQuestion, bail);

    {
        auto object = reinterpret_cast<nn::dns::parser::Question*>(pQuestion);
        auto m = reinterpret_cast<const nn::dns::parser::Message*>(pMessage);
        object->Initialize(m);
    };

bail:
    return;
};

ssize_t nndnsparserQuestionSizeOf(const struct nndnsparserQuestion* pQuestion)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pQuestion, bail);

    {
        auto object = reinterpret_cast<const nn::dns::parser::Question*>(pQuestion);
        rc = object->SizeOf();
    };

bail:
    return rc;
};

bool nndnsparserQuestionIsEqual(const struct nndnsparserQuestion* pQuestion1,
                                const struct nndnsparserQuestion* pQuestion2)
{
    bool rc = false;
    NN_DNSPARSER_ERROR_IF(nullptr == pQuestion1, bail);
    NN_DNSPARSER_ERROR_IF(nullptr == pQuestion2, bail);

    {
        auto p = reinterpret_cast<const nn::dns::parser::Question*>(pQuestion1);
        auto q = reinterpret_cast<const nn::dns::parser::Question*>(pQuestion2);
        rc = (*p) == (*q);
    };

bail:
    return rc;
};

ssize_t nndnsparserQuestionFromBuffer(struct nndnsparserQuestion* pQuestion,
                                      const uint8_t* pBuffer,
                                      size_t size)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pQuestion, bail);

    {
        auto object = reinterpret_cast<nn::dns::parser::Question*>(pQuestion);
        rc = object->FromBuffer(pBuffer, size);
    };

bail:
    return rc;
};

ssize_t nndnsparserQuestionToBuffer(uint8_t * const pBuffer,
                                    size_t size,
                                    const struct nndnsparserQuestion* pQuestion)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pQuestion, bail);

    {
        const nn::dns::parser::Question* object =
            reinterpret_cast<const nn::dns::parser::Question*>(pQuestion);
        rc = object->ToBuffer(pBuffer, size);
    };

bail:
    return rc;
};

}; // extern "C"
