﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/dns/parser.h>
#include "dns_ParserMacros.h"

extern "C"
{
#include <nnc/dns/parser.h>

void nndnsparserLabelInitialize(struct nndnsparserLabel* pLabel,
                                const struct nndnsparserMessage* pMessage)
{
    NN_DNSPARSER_ERROR_IF(nullptr == pLabel, bail);

    {
        auto object = reinterpret_cast<nn::dns::parser::Label*>(pLabel);
        auto m = reinterpret_cast<const nn::dns::parser::Message*>(pMessage);
        object->Initialize(m);
    };

bail:
    return;
};

ssize_t nndnsparserLabelSizeOf(const struct nndnsparserLabel* pLabel)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pLabel, bail);

    {
        auto object = reinterpret_cast<const nn::dns::parser::Label*>(pLabel);
        rc = object->SizeOf();
    };

bail:
    return rc;
};

bool nndnsparserLabelIsEqual(const struct nndnsparserLabel* pLabel1,
                             const struct nndnsparserLabel* pLabel2)
{
    bool rc = false;
    NN_DNSPARSER_ERROR_IF(nullptr == pLabel1, bail);
    NN_DNSPARSER_ERROR_IF(nullptr == pLabel2, bail);

    {
        auto p = reinterpret_cast<const nn::dns::parser::Label*>(pLabel1);
        auto q = reinterpret_cast<const nn::dns::parser::Label*>(pLabel2);
        rc = (*p) == (*q);
    };

bail:
    return rc;
};

ssize_t nndnsparserLabelFromBuffer(struct nndnsparserLabel* pLabel,
                                   const uint8_t* pBuffer,
                                   size_t size)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pLabel, bail);

    {
        auto object = reinterpret_cast<nn::dns::parser::Label*>(pLabel);
        rc = object->FromBuffer(pBuffer, size);
    };

bail:
    return rc;
};

ssize_t nndnsparserLabelToBuffer(uint8_t * const pBuffer,
                                 size_t size,
                                 const struct nndnsparserLabel* pLabel)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pLabel, bail);


    {
        auto object = reinterpret_cast<const nn::dns::parser::Label*>(pLabel);
        rc = object->ToBuffer(pBuffer, size);
    };

bail:
    return rc;
};


ssize_t nndnsparserLabelGetStringBufferSize(const struct nndnsparserLabel* pLabel)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pLabel, bail);

    {
        auto object = reinterpret_cast<const nn::dns::parser::Label*>(pLabel);
        rc = object->GetStringBufferSize();
    };

bail:
    return rc;
};

ssize_t nndnsparserLabelToBufferFromDomainNameString(uint8_t * const pBuffer,
                                                     size_t bufferSize,
                                                     const char* pString) NN_NOEXCEPT
{
    return nn::dns::parser::Label::ToBufferFromDomainNameString(pBuffer, bufferSize, pString);
};

ssize_t nndnsparserLabelToBufferFromHostnameString(uint8_t * const pBuffer,
                                                   size_t bufferSize,
                                                   const char* pString) NN_NOEXCEPT
{
    return nn::dns::parser::Label::ToBufferFromHostnameString(pBuffer, bufferSize, pString);
};

ssize_t nndnsparserLabelToString(char* pString, size_t size, const struct nndnsparserLabel* pLabel)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pLabel, bail);

    {
        auto object = reinterpret_cast<const nn::dns::parser::Label*>(pLabel);
        rc = object->ToString(pString, size);
    };

bail:
    return rc;
};

}; // extern "C"
