﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/dns/parser.h>
#include "dns_ParserMacros.h"

extern "C"
{
#include <nnc/dns/parser.h>

void nndnsparserHeaderInitialize(struct nndnsparserHeader* pHeader,
                                 const struct nndnsparserMessage* pMessage)
{
    NN_DNSPARSER_ERROR_IF(nullptr == pHeader, bail);

    {
        auto object = reinterpret_cast<nn::dns::parser::Header*>(pHeader);
        auto m = reinterpret_cast<const nn::dns::parser::Message*>(pMessage);
        object->Initialize(m);
    };

bail:
    return;
};

ssize_t nndnsparserHeaderSizeOf(const struct nndnsparserHeader* pHeader)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pHeader, bail);

    {
        auto object = reinterpret_cast<const nn::dns::parser::Header*>(pHeader);
        rc = object->SizeOf();
    };

bail:
    return rc;
};

bool nndnsparserHeaderIsEqual(const struct nndnsparserHeader* pHeader1,
                              const struct nndnsparserHeader* pHeader2)
{
    bool rc = false;
    NN_DNSPARSER_ERROR_IF(nullptr == pHeader1, bail);
    NN_DNSPARSER_ERROR_IF(nullptr == pHeader2, bail);

    {
        auto p = reinterpret_cast<const nn::dns::parser::Header*>(pHeader1);
        auto q = reinterpret_cast<const nn::dns::parser::Header*>(pHeader2);
        rc = (*p) == (*q);
    };

bail:
    return rc;
};

ssize_t nndnsparserHeaderFromBuffer(struct nndnsparserHeader* pHeader,
                                    const uint8_t* pBuffer,
                                    size_t size)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pHeader, bail);

    {
        auto object = reinterpret_cast<nn::dns::parser::Header*>(pHeader);
        rc = object->FromBuffer(pBuffer, size);
    };

bail:
    return rc;
};

ssize_t nndnsparserHeaderToBuffer(uint8_t * const pBuffer,
                                  size_t size,
                                  const struct nndnsparserHeader* pHeader)
{
    ssize_t rc = -1;
    NN_DNSPARSER_ERROR_IF(nullptr == pHeader, bail);


    {
        auto object = reinterpret_cast<const nn::dns::parser::Header*>(pHeader);
        rc = object->ToBuffer(pBuffer, size);
    };

bail:
    return rc;
};

}; // extern "C"
