﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "dhcps_Event.h"

//#define NN_DETAIL_DHCPS_LOG_LEVEL NN_DETAIL_DHCPS_LOG_LEVEL_DEBUG
#define NN_DETAIL_DHCPS_LOG_MODULE_NAME "Event"
#include "dhcps_Log.h"

namespace nn { namespace dhcps { namespace detail {

bool EventTypeIsPublic(EventType e) NN_NOEXCEPT
{
    if ((e >= EventType::PublicApiServerMinimum && e <= EventType::PublicApiServerMaximum) ||
        (e >= EventType::PublicApiDhcpMinimum && e <= EventType::PublicApiDhcpMaximum))
    {
        return true;
    };

    return false;
};

const char* EventTypeToString(EventType in) NN_NOEXCEPT
{
    if (EventTypeIsPublic(in))
    {
        return  EventToString(static_cast<Event>(static_cast<uint32_t>(in)));
    };

    switch (in)
    {
        NN_DETAIL_DHCPS_STRINGIFY_CASE(EventType::OnTimerExpired);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(EventType::OnPacketParseError);

        NN_DETAIL_DHCPS_STRINGIFY_CASE(EventType::OnPacketRead);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(EventType::OnPacketWrite);

        NN_DETAIL_DHCPS_STRINGIFY_CASE(EventType::OnFileOpen);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(EventType::OnFileRead);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(EventType::OnFileWrite);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(EventType::OnFileExcept);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(EventType::OnFileClose);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(EventType::OnFileError);

    default:
        ;
    };

    return "Unknown Event Type";
};

InternalEvent::InternalEvent(EventType type, const void* value, size_t size) NN_NOEXCEPT :
m_Type(type), m_Value(value), m_Size(size)
{
    NN_DETAIL_DHCPS_LOG_DEBUG("InternalEvent: %p, type: %s (%d), value: %p, size: %zu\n",
                              this, EventTypeToString(m_Type), m_Type, m_Value, m_Size);
}

EventType InternalEvent::GetType() const NN_NOEXCEPT
{
    return m_Type;
};

size_t InternalEvent::GetSize() const NN_NOEXCEPT
{
    return m_Size;
};

const void* InternalEvent::GetValue() const NN_NOEXCEPT
{
    return m_Value;
};


}}}; // nn::dhcps::detail
