﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEventTypes.h>
#include <nn/util/util_Execution.h>

namespace nn { namespace dauth { namespace detail {
class IAsyncResult;
}}} // ~namespace nn::dauth::detail

namespace nn { namespace dauth { namespace detail {

class AsyncResult
{
    friend void swap(AsyncResult& o0, AsyncResult& o1) NN_NOEXCEPT;

private:
    IAsyncResult* m_Ptr {nullptr};

public:
    AsyncResult() NN_NOEXCEPT = default;
    explicit AsyncResult(IAsyncResult* ptr) NN_NOEXCEPT;
    AsyncResult(AsyncResult&& rhs) NN_NOEXCEPT;
    ~AsyncResult() NN_NOEXCEPT;

    AsyncResult& operator =(AsyncResult&& rhs) NN_NOEXCEPT;

    Result GetResult() const NN_NOEXCEPT;
    NN_EXPLICIT_OPERATOR Result() const NN_NOEXCEPT
    {
        return GetResult();
    }

    void Cancel() NN_NOEXCEPT;
    bool IsAvailable() NN_NOEXCEPT;

    void GetSharedSystemEvent(os::SystemEventType* pEvent) const NN_NOEXCEPT;
};

void swap(AsyncResult& o0, AsyncResult& o1) NN_NOEXCEPT;

class CancelAttachment
{
private:
    class Listener
        : public util::Cancelable::Listener
    {
    private:
        AsyncResult& m_Async;

    public:
        explicit Listener(AsyncResult& async) NN_NOEXCEPT
            : m_Async(async)
        {
        }
        virtual void Signal() NN_NOEXCEPT
        {
            m_Async.Cancel();
        }
    } m_Impl;
    util::Cancelable& m_Cancelable;

public:
    CancelAttachment(util::Cancelable& cancelable, AsyncResult& async) NN_NOEXCEPT
        : m_Impl(async)
        , m_Cancelable(cancelable)
    {
        m_Cancelable.AttachListener(&m_Impl);
    }
    ~CancelAttachment() NN_NOEXCEPT
    {
        m_Cancelable.DetachListener();
    }
};

}}} // ~namespace nn::dauth::detail
