﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>

#include <nn/codec/codec_OpusCommon.h>
#include <nn/codec/codec_OpusEncoderTypes.h>
#include <nn/codec/detail/codec_OpusPacketInternal.h>

namespace nn {
namespace codec {
namespace detail {

void OpusPacketInternal::SetHeaderInPacket(uint8_t* pPacket, const struct Header& header) NN_NOEXCEPT
{
    // packetSize
    pPacket[0] = (header.packetSize >> 24) & 0xff;
    pPacket[1] = (header.packetSize >> 16) & 0xff;
    pPacket[2] = (header.packetSize >>  8) & 0xff;
    pPacket[3] = (header.packetSize >>  0) & 0xff;
    // finalRange
    pPacket[4] = (header.finalRange >> 24) & 0xff;
    pPacket[5] = (header.finalRange >> 16) & 0xff;
    pPacket[6] = (header.finalRange >>  8) & 0xff;
    pPacket[7] = (header.finalRange >>  0) & 0xff;
}

void OpusPacketInternal::GetHeaderFromPacket(struct Header* pHeader, const uint8_t* pPacket) NN_NOEXCEPT
{
    uint32_t packetSize = 0;
    uint32_t finalRange = 0;

    packetSize = (pPacket[0] << 24)
        | (pPacket[1] << 16)
        | (pPacket[2] <<  8)
        | (pPacket[3] <<  0);

    finalRange = (pPacket[4] << 24)
        | (pPacket[5] << 16)
        | (pPacket[6] <<  8)
        | (pPacket[7] <<  0);

    pHeader->packetSize = packetSize;
    pHeader->finalRange = finalRange;
}

OpusResult OpusPacketInternal::GetOpusPacketCodingMode(OpusCodingMode* pOutCodingMode, const uint8_t packet[], size_t packetSize) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(packet != nullptr);
    NN_SDK_REQUIRES(packetSize >= detail::OpusPacketInternal::HeaderSize + 1);
    NN_UNUSED(packetSize);

    // 以下のビット操作や、12、16 の意味について、RFC 6716 P.14-15 を参照
    const uint8_t config = (packet[detail::OpusPacketInternal::HeaderSize] >> 3) & 0x1f;
    if (config < 12)
    {
        *pOutCodingMode = OpusCodingMode_Silk;
    }
    else if (config < 16)
    {
        *pOutCodingMode = OpusCodingMode_Hybrid;
    }
    else
    {
        *pOutCodingMode = OpusCodingMode_Celt;
    }
    return OpusResult_Success;
}


}}}  // nn::codec::detail
