﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/sf/sf_HipcClientProxyByName.h>     // for nn::sf::CreateHipcProxyByName
#include <nn/sf/sf_ExpHeapAllocator.h>          // for nn::sf::ExpHeapStaticAllocator

#include "codec_HardwareOpusDecoderManagerImpl.h"

#include "detail/codec_ServiceName.h"           // for ServiceName

namespace nn { namespace codec {

namespace {

// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備します。
struct CreateHardwareOpusDecoderByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateHardwareOpusDecoderByHipcTag> MyAllocator;

// MyAllocator を静的コンストラクタで初期化するためのヘルパー
class MyAllocatorInitializer
{
public:
    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }
} g_MyAllocatorInitializer;

}

// 機能へのアクセスは共有ポインタを利用します。
// 共有ポインタを返却する関数を作成し、サービス利用者はその関数で得られた共有ポインタを利用して、機能にアクセスします。
nn::sf::SharedPointer<detail::IHardwareOpusDecoderManager> CreateHardwareOpusDecoderManagerByHipc() NN_NOEXCEPT
{
    // codecHardwareOpusDecoderManagerServiceName のサービス名で示される HIPC サービスオブジェクトを、
    // IHardwareOpusDecoderManager としてプロキシクライアントを作成して返します。
    // アロケーションポリシーとして MyAllocator::Policy を渡します。
    nn::sf::SharedPointer<detail::IHardwareOpusDecoderManager> ret;
    auto result = nn::sf::CreateHipcProxyByName<detail::IHardwareOpusDecoderManager, MyAllocator::Policy>(&ret, CodecHardwareOpusDecoderServiceName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return ret;
}

}}  // namespace nn::codec
