﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdint.h>

#include "cec_TopLevelFiniteStateMachine.h"

namespace nn { namespace cec { namespace detail {

const uint8_t CecReceiveParamMaxMessageLength = 16;
const uint8_t CecReceiveParamBroadcastLogicalAddress  = 0x0F;
const uint8_t CecReceiveParamFreeUseLogicalAddress    = 0x0E;
const uint8_t CecReceiveParamUnassignedLogicalAddress = 0x0F;
const uint8_t CecReceiveParamTvLogicalAddress         = 0x00;

/* per CEC 1.3a spec, sections 5.2 and 9.1 */
extern const uint32_t CecReceiveParamBitPeriodNanoSeconds;
extern const uint32_t CecReceiveParamFrameToFrameDelayNanoSeconds;
extern const uint32_t CecReceiveParamErrorToNextDelayNanoSeconds;
extern const uint32_t CecReceiveParamCradleFirmwareBugWorkAroundNanoSeconds;

const uint8_t CecBufferLogicalAddressIndex = 0;
const uint8_t CecBufferOpcodeIndex = 1;
const uint8_t CecBufferPayloadIndex = 2;
const uint8_t CecBufferFeatureAbortOpcodeIndex = 2;

const uint8_t CecBufferElementCountIsOne = 1;
const uint8_t CecBufferElementCountIsTwo = 2;
const uint8_t CecBufferElementCountIsThree = 3;
const uint8_t CecBufferElementCountIsFour = 4;
const uint8_t CecBufferElementCountIsFive = 5;
const uint8_t CecBufferElementCountIsSix = 6;

int32_t CecReceiverSendVendorId(bool* pIsSent) NN_NOEXCEPT;
int32_t CecReceiverSendInactiveSource() NN_NOEXCEPT;
int32_t CecReceiverSendActiveSourceCommand(bool trackHpdChange) NN_NOEXCEPT;
int32_t CecReceiverSendImageViewOnCommand() NN_NOEXCEPT;
int32_t CecReceiverSendActiveSource() NN_NOEXCEPT;
int32_t CecReceiverSendDeviceMenuActivationCommand(bool activate) NN_NOEXCEPT;
int32_t CecReceiverSendRemoteControlCommand(bool start, uint8_t argument) NN_NOEXCEPT;
int32_t CecReceiverSendOnScreenDisplay(uint8_t* string) NN_NOEXCEPT;
int32_t CecReceiverSendGoStandby(bool tvOnly) NN_NOEXCEPT;
int32_t CecReceiverInit() NN_NOEXCEPT;
void    CecReceiverShutdown() NN_NOEXCEPT;
int32_t CecReceiverStart(OperatingStateType* pOpState, EdidVariationType* pEdidVariation) NN_NOEXCEPT;
int32_t CecReceiverStop() NN_NOEXCEPT;
void    CecReceiverSendFeatureAbort(uint8_t sourceLogicalAddress, uint8_t destinationLogicalAddress, uint8_t opcode, uint8_t reason) NN_NOEXCEPT;
void    CecReceiverSendFeatureAbortNop(uint8_t sourceLogicalAddress, uint8_t destinationLogicalAddress, uint8_t opcode, uint8_t reason) NN_NOEXCEPT;

}
}   // namespace cec
}   // namespace nn
