﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdint.h>
#include <nn/nn_Common.h>

namespace nn { namespace cec { namespace server {

const uint32_t CecEventActiveSource             = (1 << 0);
const uint32_t CecEventGoStandby                = (1 << 1);
const uint32_t CecEventHpdDisconnect            = (1 << 2);
const uint32_t CecEventHpdConnect               = (1 << 3);
const uint32_t CecEventSuspending               = (1 << 4);
const uint32_t CecEventOtpFeatureAbort          = (1 << 5);
const uint32_t CecEventStandbyFeatureAbort      = (1 << 6);
const uint32_t CecEventSetOsdStringFeatureAbort = (1 << 7);
const uint32_t CecEventDeviceMenuControlFeatureAbort = (1 << 8);
const uint32_t CecEventStarted                  = (1 << 9);

void CecManagerImplOnEvent(uint32_t eventFlags, uint32_t count, uint8_t dataBuffer[]) NN_NOEXCEPT;

}}}
