﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/dd.h>

#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/impl/sf_StaticOneAllocator.h>
#include <nn/sf/impl/sf_ExpHeapAllocator.h>

#include <nn/cec/cec_Types.h>

#include "cec_Receiver.h"
#include "cec_ICecManager.h"

namespace nn { namespace cec { namespace server {

const uint32_t maxSessionCount = 30;

class CecManagerImpl
{
public:

    CecManagerImpl() NN_NOEXCEPT;
    ~CecManagerImpl() NN_NOEXCEPT;
    int32_t RegisterCallback(nn::sf::Out<nn::sf::NativeHandle> registrationEventHandle,
                             nn::sf::Out<uint32_t> handleValue) NN_NOEXCEPT;
    int32_t UnregisterCallback(uint32_t handleValue) NN_NOEXCEPT;
    nn::Result TriggerSystemEvent(uint32_t handleValue) NN_NOEXCEPT;
    int32_t PerformAction(uint32_t action, uint64_t dataZero, uint64_t dataOne) NN_NOEXCEPT;
    int32_t QueryState(uint32_t query, nn::sf::Out<uint64_t> pDataZero, nn::sf::Out<uint64_t> pDataOne) NN_NOEXCEPT;
    int32_t OnSystemEvent(nn::sf::Out<uint32_t> pEvent,
                          nn::sf::Out<uint32_t> pCount,
                          nn::sf::Out<uint64_t> pDataZero,
                          nn::sf::Out<uint64_t> pDataOne) NN_NOEXCEPT;
    int32_t CancelCurrentCall(nn::sf::Out<bool> pCallWasCanceled) NN_NOEXCEPT;
    nn::Result GetHdcpServiceObject(nn::sf::Out<nn::sf::SharedPointer<nn::hdcp::detail::IHdcpController>> outService) NN_NOEXCEPT;

private:

};

typedef union {
    uint8_t     byteArray[sizeof(uint64_t)];
    uint64_t    ullValue;
} UllToByte;

typedef enum
{
    ActionType_OneTouchPlay,
    ActionType_ImageViewOn,
    ActionType_ActiveSource,
    ActionType_InactiveSource,
    ActionType_SetActiveSourceState,
    ActionType_GoStandby,
    ActionType_SetPowerState,
    ActionType_SuspendManager,
    ActionType_RestartManager,
    ActionType_SetOnScreenDisplay,
    ActionType_RemoteControlCommand,
    ActionType_DeviceMenuCommand
} ActionType;

typedef enum
{
    QueryType_IfStarted,
    QueryType_PowerState,
    QueryType_TvPowerState,
    QueryType_ConnectionState,
    QueryType_HpdState,
    QueryType_IfEnabled,
    QueryType_IfActiveSource,
    QueryType_CanPingTv,
    QueryType_CancelCurrentCall
} QueryType;

typedef union
{
    PowerState      powerStateValue;
    ConnectionState connectionStateValue;
    bool            booleanValue;
    int             integerValue;
    uint8_t         byteArray[detail::CecReceiveParamMaxMessageLength];
    uint64_t        ullArray[detail::CecReceiveParamMaxMessageLength / sizeof(uint64_t)];
} ShimDataTransferType;

}}}
