﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdint.h>
#include <cec_TransmitterFiniteStateMachine.h>

namespace nn { namespace cec { namespace detail {

const int32_t CecDisplayPortParamNoError = 0;

int32_t CecDisplayPortInit(void* pContext) NN_NOEXCEPT;
int32_t CecDisplayPortShutdown() NN_NOEXCEPT;
int32_t CecDisplayPortStart(void* pContext) NN_NOEXCEPT;
int32_t CecDisplayPortStop() NN_NOEXCEPT;
int32_t CecDisplayPortUnhookCallbacks() NN_NOEXCEPT;
int32_t CecDisplayPortGetConnectionStatus(uint32_t* pOutHpdStatus, uint32_t* pOutSinkStatus) NN_NOEXCEPT;
int32_t CecDisplayPortLastTraffic(uint32_t* pDeltaUs) NN_NOEXCEPT;
int32_t CecDisplayPortEnable(bool enable) NN_NOEXCEPT;
int32_t CecDisplayPortGetPhysicalAddress(uint8_t* pPhysicalAddress) NN_NOEXCEPT;
int32_t CecDisplayPortSetLogicalAddress(uint8_t logicalAddress) NN_NOEXCEPT;
int32_t CecDisplayPortReadData(uint8_t* pReadBuffer, int* pReadByteCount) NN_NOEXCEPT;
int32_t CecDisplayPortTransmitData(TransmitReturnValueType* pTransmitReturnValue,
                                   uint8_t* pBuffer, uint8_t count) NN_NOEXCEPT;

}
}   // namespace cec
}   // namespace nn
