﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief
 *
 * @details
 */

namespace nn {
namespace cdmsc {
namespace driver {

/*
 * Ref [MSC Spec Overview r1.4] Table 1
 */
enum MscSubclass
{
    MscSubclass_Ufi  = 0x04,
    MscSubclass_Scsi = 0x06,
};

/*
 * Ref [MSC Spec Overview r1.4] Table 2
 */
enum MscProtocol
{
    MscProtocol_Bbb = 0x50,
    MscProtocol_Uas = 0x62,
};

enum DeviceCapability
{
    DeviceCapability_SyncCache10   = 1 << 0,
    DeviceCapability_ModeSense10   = 1 << 1,
};

} // driver
} // cdmsc
} // nn
