﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../detail/cdmsc_Utils.h"

/**
 * @file
 * @brief
 *
 * @details
 */

namespace nn {
namespace cdmsc {
namespace driver {

/*
 * SCSI Command Operation Code
 */
enum ScsiCommand
{
    ScsiCommand_TestUnitReady  = 0x00,
    ScsiCommand_RequestSense   = 0x03,
    ScsiCommand_ReadCapacity10 = 0x25,
    ScsiCommand_ReadCapacity16 = 0x9e,
    ScsiCommand_ModeSense10    = 0x5a,
    ScsiCommand_StartStopUnit  = 0x1b,
    ScsiCommand_SyncCache10    = 0x35,
    ScsiCommand_Read10         = 0x28,
    ScsiCommand_Write10        = 0x2a,
    ScsiCommand_Read16         = 0x88,
    ScsiCommand_Write16        = 0x8a,
    ScsiCommand_Inquiry        = 0x12,
};

/*
 * SCSI Command Descriptor Block (CDB)
 */
struct ScsiTestUnitReady
{
    uint8_t        opCode;
    uint8_t        reserved[4];
    uint8_t        control;
} NN_CDMSC_PACKED;

struct ScsiRequestSense
{
    uint8_t        opCode;
    uint8_t        desc;
    uint8_t        reserved[2];
    uint8_t        allocationLength;
    uint8_t        control;
} NN_CDMSC_PACKED;

struct ScsiReadCapacity10
{
    uint8_t        opCode;
    uint8_t        reserved1;
    uint32_t       lba;
    uint8_t        reserved2[2];
    uint8_t        pmi;
    uint8_t        control;
} NN_CDMSC_PACKED;

struct ScsiReadCapacity16
{
    uint8_t        opCode;
    uint8_t        serviceAction;
    uint64_t       lba;
    uint32_t       allocationLength;
    uint8_t        pmi;
    uint8_t        control;
} NN_CDMSC_PACKED;

struct ScsiModeSense10
{
    uint8_t        opCode;
    uint8_t        llbaa_dbd;
    uint8_t        pc_pageCode;
    uint8_t        subpageCode;
    uint8_t        reserved[3];
    uint16_t       allocationLength;
    uint8_t        control;
} NN_CDMSC_PACKED;

struct ScsiStartStopUnit
{
    uint8_t        opCode;
    uint8_t        immed;
    uint8_t        reserved[1];
    uint8_t        powerConditionModifier;
    uint8_t        powerCondition_noFlush_loej_start;
    uint8_t        control;
} NN_CDMSC_PACKED;

struct ScsiSyncCache10
{
    uint8_t        opCode;
    uint8_t        syncNv_immed;
    uint32_t       lba;
    uint8_t        groupNumber;
    uint16_t       numberOfBlocks;
    uint8_t        control;
} NN_CDMSC_PACKED;

struct ScsiRead10
{
    uint8_t        opCode;
    uint8_t        rdprotect_dpo_fua_rarc_fuaNv;
    uint32_t       lba;
    uint8_t        groupNumber;
    uint16_t       transferLength;
    uint8_t        control;
} NN_CDMSC_PACKED;

struct ScsiWrite10
{
    uint8_t        opCode;
    uint8_t        wrprotect_dpo_fua_fuaNv;
    uint32_t       lba;
    uint8_t        groupNumber;
    uint16_t       transferLength;
    uint8_t        control;
} NN_CDMSC_PACKED;

struct ScsiRead16
{
    uint8_t        opCode;
    uint8_t        rdprotect_dpo_fua_rarc_fuaNv;
    uint64_t       lba;
    uint32_t       transferLength;
    uint8_t        groupNumber;
    uint8_t        control;
} NN_CDMSC_PACKED;

struct ScsiWrite16
{
    uint8_t        opCode;
    uint8_t        wrprotect_dpo_fua_fuaNv;
    uint64_t       lba;
    uint32_t       transferLength;
    uint8_t        groupNumber;
    uint8_t        control;
} NN_CDMSC_PACKED;

struct ScsiInquiry
{
    uint8_t        opCode;
    uint8_t        evpd;
    uint8_t        pageCode;
    uint16_t       transferLength;
    uint8_t        control;
} NN_CDMSC_PACKED;

/*
 * SCSI Command Parameter Data
 */
struct ScsiRequestSenseData
{
    uint8_t        valid_responseCode;
    uint8_t        obsolete;
    uint8_t        filemark_eom_ili_senseKey;
    uint8_t        information[4];
    uint8_t        additionalSenseLength;
    uint8_t        commandSpecificInformation[4];
    uint8_t        additionalSenseCode;
    uint8_t        additionalSenseCodeQualifier;
    uint8_t        fieldReplaceableUnitCode;
    uint8_t        senseKeySpecific[3];
} NN_CDMSC_PACKED;

struct ScsiReadCapacity10Data
{
    uint32_t       lba;
    uint32_t       blockLength;
} NN_CDMSC_PACKED;

struct ScsiReadCapacity16Data
{
    uint64_t       lba;
    uint32_t       blockLength;
    uint8_t        pType_protEn;
    uint8_t        PIExp_lbPerPbExp;
    uint16_t       lbpme_lbprz_lowestAlignedLba;
    uint8_t        reserved[16];
} NN_CDMSC_PACKED;

struct ScsiModeParameterHeader10
{
    uint16_t       modeDataLength;
    uint8_t        mediumType;
    uint8_t        wp_dpofua;
    uint8_t        longlba;
    uint8_t        reserved;
    uint16_t       blockDescriptorLength;
} NN_CDMSC_PACKED;

struct ScsiInquiryData
{
    uint8_t peripheralQualifer_peripheralDeviceType;
    uint8_t rmb;
    uint8_t version;
    uint8_t normaca_hisup_responseDataFormat;
    uint8_t additionalLength;
    uint8_t sccs_acc_tpgs_3pc_protect;
    uint8_t encserv_vs_multip_mchngr_addr16;
    uint8_t wbus16_sync_cmdque_vs;
    uint8_t vendorInformation[8];
    uint8_t productInformation[16];
    uint8_t productRevisionLevel[4];
} NN_CDMSC_PACKED;

const size_t ScsiSenseDataMaxLength = 252;

} // driver
} // cdmsc
} // nn
