﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/bpc/bpc_WakeupConfigTypes.h>

namespace nn { namespace bpc { namespace driver { namespace detail {

class WakeupTimer
{
public:
    void SetTargetRtcTime(int64_t rtcTimeInSeconds) NN_NOEXCEPT
    {
        m_TargetRtcTime = rtcTimeInSeconds;
    }
    int64_t GetTargetRtcTime() const NN_NOEXCEPT
    {
        return m_TargetRtcTime;
    }
    void SetType(WakeupTimerType type) NN_NOEXCEPT
    {
        m_Type = type;
    }
    WakeupTimerType GetType() const NN_NOEXCEPT
    {
        return m_Type;
    }
    void SetHandle(int handle) NN_NOEXCEPT
    {
        m_Handle = handle;
    }
    int GetHandle() const NN_NOEXCEPT
    {
        return m_Handle;
    }

public:
    util::IntrusiveListNode     m_Node;

private:
    int64_t                     m_TargetRtcTime{ 0LL };
    WakeupTimerType             m_Type{ WakeupTimerType_None };
    int                         m_Handle{ 0 };
};

typedef nn::util::IntrusiveList<WakeupTimer, nn::util::IntrusiveListMemberNodeTraits<WakeupTimer, &WakeupTimer::m_Node>>  WakeupTimerList;

class WakeupTimerArbiter
{
public:
    nn::Result Register(WakeupTimer* pTimer) NN_NOEXCEPT;
    nn::Result Unregister(WakeupTimer* pTimer) NN_NOEXCEPT;
    nn::Result UpdateDevice(bool *pOutIsEnabled, const WakeupTimer** ppOutEnabledTimer) NN_NOEXCEPT;
    nn::Result CleanAllWakeupTimers(WakeupTimerType type) NN_NOEXCEPT;
    WakeupTimerType GetLastEnabledWakeupTimerType() const NN_NOEXCEPT
    {
        return m_LastEnabledWakeupTimerType;
    }

private:
    void InsertByTime(WakeupTimer* pTimer) NN_NOEXCEPT;

private:
    WakeupTimerList     m_RegisteredTimerList;
    WakeupTimerType     m_LastEnabledWakeupTimerType = WakeupTimerType_None;
};

WakeupTimer* AllocateWakeupTimer() NN_NOEXCEPT;
WakeupTimer* GetWakeupTimer(int handle) NN_NOEXCEPT;
void FreeWakeupTimer(WakeupTimer* pTimer) NN_NOEXCEPT;

WakeupTimerArbiter& GetWakeupTimerArbiter() NN_NOEXCEPT;

}}}} // namespace nn::bpc::driver::detail
