﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/bpc/driver/bpc_Rtc.h>

namespace nn { namespace bpc { namespace driver { namespace detail {

void InitializeExternalRtc(bool recoveryFromRtcReset) NN_NOEXCEPT;

nn::Result GetRtcTime(int64_t *pOutRtcTimeInSeconds) NN_NOEXCEPT;
nn::Result SetRtcTime(int64_t rtcTimeInSeconds) NN_NOEXCEPT;

enum class RtcAlarmType : uint8_t {
    Wakeup,    // システムを起床させるアラーム
    QuasiOff, // システムを擬似オフ状態で起床させるアラーム
};

nn::Result EnableRtcAlarm(int64_t targetTime, RtcAlarmType type) NN_NOEXCEPT;
nn::Result DisableRtcAlarm(RtcAlarmType type) NN_NOEXCEPT;
nn::Result GetRtcResetDetected(bool* pOutRtcResetDetected) NN_NOEXCEPT;
nn::Result ClearRtcResetDetected() NN_NOEXCEPT;
nn::Result SetUpRtcResetOnShutdown() NN_NOEXCEPT;
void NotifyShutdownToRtc() NN_NOEXCEPT;

}}}} // namespace nn::bpc::driver::detail
