﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_ContextControl.h>
#include <nn/bgsu/bgsu_MultiClientSystemEvent.h>

#include "bgtc_Common.h"
#include "bgtc_ClientBroker.h"

namespace nn { namespace bgtc {

class TaskServiceImpl
{
public:
    TaskServiceImpl();
    ~TaskServiceImpl();

    nn::Result NotifyTaskStarting() NN_NOEXCEPT;
    nn::Result NotifyTaskFinished() NN_NOEXCEPT;
    nn::Result GetTriggerEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result NotifyClientName(const nn::sf::InArray<char>& name) NN_NOEXCEPT;
    nn::Result ScheduleTask(std::int32_t intervalSeconds) NN_NOEXCEPT;
    nn::Result SchedulePeriodicTask(std::int32_t intervalSecondsFirst, std::int32_t intervalSecondsPeriodic) NN_NOEXCEPT;
    nn::Result GetScheduledTaskInterval(nn::sf::Out<std::int32_t> outSeconds) NN_NOEXCEPT;
    nn::Result UnscheduleTask() NN_NOEXCEPT;
    nn::Result GetScheduleEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;

    static nn::Result IsInHalfAwake(nn::sf::Out<bool> bResult) NN_NOEXCEPT;
    static nn::Result IsInFullAwake(nn::sf::Out<bool> bResult) NN_NOEXCEPT;
    static nn::Result GetOperationMode(nn::sf::Out<nn::bgtc::OperationMode> outOperationMode) NN_NOEXCEPT;
    static nn::Result WillDisconnectNetworkWhenEnteringSleep(nn::sf::Out<bool> bResult);
    static nn::Result WillStayHalfAwakeInsteadSleep(nn::sf::Out<bool> bResult);

private:
    ClientBroker::Entry m_ClientEntry;
    bgsu::MultiClientSystemEvent::Node m_EventNodeForTrigger;
    os::SystemEvent m_SystemEventForSchedule;
};

}}
