﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os.h>
#include <nn/bgtc/bgtc_Types.h>

namespace nn{ namespace bgtc{

class BatterySaver
{
public:
    const TimeSpan PollingInterval = TimeSpan::FromSeconds(60);

    BatterySaver();
    static int GetBatteryChargePercentage();
    static OperationMode JudgeInternalOperationModeByPowerState();
    OperationMode JudgeOperationMode() const;
    Interval GetHalfAwakeMinimumInterval(OperationMode operationMode) const;
    Interval CalculateHalfAwakeInterval(OperationMode operationMode, Time nearestScheduled, bool bBatteryAware) const;
    static bool IsEnabled();
    void NotifyFullAwakeOrHalfAwakeLeaving();
    bool SetIsUsingSleepUnsupportedDevices(bool bIsUsingSleepUnsupportedDevices);
    bool IsUsingSleepUnsupportedDevices() const;
    bool ShouldCareAboutSleepUnsupportedDevices();


    // 変化検出イベントと名乗りつつも実際はタイマ（psm に機能が追加されるのを期待）
    os::TimerEvent& GetChangedEvent()
    {
        return m_ChangeEvent;
    }
    bool IsStopRequired() const
    {
        return JudgeOperationMode() == OperationMode_Stop;
    }

    static const char* GetOperationModeString(OperationMode mode);

protected:



private:
    os::TimerEvent m_ChangeEvent;
    Time m_LatestFullAwakeOrHalfAwakeLeavingTime;
    bool m_bIsUsingSleepUnsupportedDevices;
};

}}


