﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/bgtc/bgtc_Types.h>
#include <nn/bgsu/bgsu_MultiClientSystemEvent.h>

#include "bgtc_Common.h"

namespace nn{ namespace bgtc{

class BatterySaver;
class BackgroundStateEventHandler
{
    const TimeSpan LeavingHalfAwakeMarginDefault = TimeSpan::FromSeconds(3);
public:
    enum EventCode
    {
        EventCode_EnteringHalfAwake,
        EventCode_LeavingHalfAwake,
        EventCode_EteringSleep,
        EventCode_ChangedClientTaskState,
        EventCode_SignaledTimer,
        EventCode_StopByBatterySaver,
        EventCode_ChangedDeviceState,
    };

    NN_IMPLICIT BackgroundStateEventHandler(BatterySaver& bs);
    ~BackgroundStateEventHandler();

    State GetState() const
    {
        return m_State;
    }

    void TriggerEvent(EventCode eventCode);
    os::TimerEvent& GetTimerEvent();

    static const char* GetEventCodeString(EventCode eventCode);
    static const char* GetStateString(State state);

    void AttachStateChangeEvent(bgsu::MultiClientSystemEvent::Node* pEventNode);
    void DetachStateChangeEvent(bgsu::MultiClientSystemEvent::Node* pEventNode);

    void SetIsUsingSleepUnsupportedDevices(bool bIsUsingSleepUnsupportedDevices);
    bool WillDisconnectNetworkWhenEnteringSleep() const;
    bool WillStayHalfAwakeInsteadSleep() const;

protected:
    void StartTimer();
    void StopTimer();
    bool IsProcessingClientExists() const;
//    bool IsElapsedMarginTime() const;
    void SetState(State state);

private:
    os::TimerEvent m_TimerEvent;
    os::SystemEvent m_EventController;
    bgsu::MultiClientSystemEvent  m_StateChangeEvent;
    os::Mutex m_Mutex;
    TimeSpan m_LeavingHalfAwakeMargin;
    BatterySaver& m_BatterySaver;

    State m_State;
};

}}
