﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/bgsu/bgsu_MultiClientSystemEvent.h>

namespace nn {
namespace bgsu {

MultiClientSystemEvent::MultiClientSystemEvent() NN_NOEXCEPT
    : m_Mutex(true)
{
}

void MultiClientSystemEvent::Attach(Node * pNode) NN_NOEXCEPT
{
    std::lock_guard<os::Mutex> lock(m_Mutex);

    m_List.push_back(*pNode);
}

void MultiClientSystemEvent::Detach(Node * pNode) NN_NOEXCEPT
{
    std::lock_guard<os::Mutex> lock(m_Mutex);

    m_List.erase(m_List.iterator_to(*pNode));
}

void MultiClientSystemEvent::Clear() NN_NOEXCEPT
{
    std::lock_guard<os::Mutex> lock(m_Mutex);

    for (auto& node : m_List)
    {
        node.Clear();
    }
}

void MultiClientSystemEvent::Signal() NN_NOEXCEPT
{
    std::lock_guard<os::Mutex> lock(m_Mutex);

    for (auto& node : m_List)
    {
        node.Signal();
    }
}

}
}
