﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_FormatString.h>
#include <nn/bgsu/bgsu_FunctionTracer.h>

namespace nn{ namespace bgsu{

FunctionTracer::FunctionTracer(int line, const char* file, const char* function, const char* module, nn::diag::LogSeverity serverity)
    : m_bPrintLeavingRequired(false)
{
    m_logMetaData.sourceInfo.lineNumber = line;
    m_logMetaData.sourceInfo.fileName = file;
    m_logMetaData.sourceInfo.functionName = function;
    m_logMetaData.moduleName = module;
    m_logMetaData.severity = serverity;
    m_logMetaData.verbosity = 0;
    m_logMetaData.pAdditionalData = static_cast<void*>(0);
    m_logMetaData.additionalDataBytes = 0;
}

FunctionTracer::~FunctionTracer()
{
    if (m_bPrintLeavingRequired)
    {
        PrintLeaving("");
    }
}

void FunctionTracer::PrintEntering(const char* fmt, ...)
{
    char buffer[64];
    std::va_list list;
    va_start(list, fmt);
    nn::util::VSNPrintf(buffer, sizeof(buffer), fmt, list);
    va_end(list);
    ::nn::diag::detail::LogImpl(m_logMetaData, "entering: %s%s\n", m_logMetaData.sourceInfo.functionName, buffer);

    m_bPrintLeavingRequired = true;
}

void FunctionTracer::PrintLeaving(const char * fmt, ...)
{
    char buffer[64];
    std::va_list list;
    va_start(list, fmt);
    nn::util::VSNPrintf(buffer, sizeof(buffer), fmt, list);
    va_end(list);
    ::nn::diag::detail::LogImpl(m_logMetaData, "leaving:  %s%s\n", m_logMetaData.sourceInfo.functionName, buffer);

    m_bPrintLeavingRequired = false;
}

}
}
