﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/bcat/bcat_ApiDebug.h>
#include <nn/bcat/detail/bcat_ErrorHandler.h>
#include <nn/bcat/detail/bcat_ShimLibraryGlobal.h>

namespace nn { namespace bcat {

nn::Result EnumerateBackgroundDeliveryTask(int* outCount, TaskInfo* outInfos, int count) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outCount);
    NN_SDK_REQUIRES_NOT_NULL(outInfos);
    NN_SDK_REQUIRES_GREATER(count, 0);

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    int32_t actualCount = 0;

    NN_DETAIL_BCAT_IPC_RESULT_DO(session->EnumerateBackgroundDeliveryTask(&actualCount, nn::sf::OutArray<TaskInfo>(outInfos, count)));

    *outCount = actualCount;

    NN_RESULT_SUCCESS;
}

nn::Result BlockDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_EQUAL(appId, nn::ApplicationId::GetInvalidId());

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    NN_DETAIL_BCAT_IPC_RESULT_DO(session->BlockDeliveryTask(appId));

    NN_RESULT_SUCCESS;
}

nn::Result UnblockDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_EQUAL(appId, nn::ApplicationId::GetInvalidId());

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    NN_DETAIL_BCAT_IPC_RESULT_DO(session->UnblockDeliveryTask(appId));

    NN_RESULT_SUCCESS;
}

nn::Result GetDeliveryList(size_t* outSize, void* buffer, size_t size, nn::ApplicationId appId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outSize);
    NN_SDK_REQUIRES_NOT_NULL(buffer);
    NN_SDK_REQUIRES_GREATER(size, 0u);
    NN_SDK_REQUIRES_NOT_EQUAL(appId, nn::ApplicationId::GetInvalidId());

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    uint64_t actualSize = 0;

    NN_DETAIL_BCAT_IPC_RESULT_DO(session->GetDeliveryList(&actualSize, nn::sf::OutBuffer(reinterpret_cast<char*>(buffer), size), appId));

    *outSize = static_cast<size_t>(actualSize);

    NN_RESULT_SUCCESS;
}

nn::Result ClearDeliveryCacheStorage(nn::ApplicationId appId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_EQUAL(appId, nn::ApplicationId::GetInvalidId());

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    NN_DETAIL_BCAT_IPC_RESULT_DO(session->ClearDeliveryCacheStorage(appId));

    NN_RESULT_SUCCESS;
}

nn::Result GetPushNotificationLog(int* outCount, PushNotificationLog* outLogs, int count) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outCount);
    NN_SDK_REQUIRES_NOT_NULL(outLogs);
    NN_SDK_REQUIRES_GREATER(count, 0);

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    int32_t actualCount = 0;

    NN_DETAIL_BCAT_IPC_RESULT_DO(session->GetPushNotificationLog(&actualCount, nn::sf::OutArray<PushNotificationLog>(outLogs, count)));

    *outCount = actualCount;

    NN_RESULT_SUCCESS;
}

}}
