﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

#include <nn/audioctrl/detail/audioctrl_IAudioController.h>
#include "../server/detail/audioctrl_AudioControllerImpl.h"
#include "audioctrl_CreateAudioController.h"
#include "audioctrl_ServiceName.h"

namespace nn { namespace audioctrl { namespace detail {

nn::sf::UnmanagedServiceObject<detail::IAudioController, server::detail::AudioControllerImpl> g_AudioController;

nn::sf::SharedPointer<detail::IAudioController> CreateAudioControllerByDfc() NN_NOEXCEPT
{
    return g_AudioController.GetShared();
}

}}}  // namespace nn::audioctrl::detail

