﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Applet;
using nn;
using nn.sf;
using std;

namespace nn.audio
{
    [CppRefPath(@"<nn/audio/audio_AudioInTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct AudioInParameter
    {
    }
}

namespace nn.applet
{
    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }

    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [CheckAppletResourceUserId]
    [CppFullName("nn::applet::AppletResourceUserId")]
    [ExternalStruct(8, 8)]
    public struct CheckedAppletResourceUserId
    {
    }
}

namespace nn.audio.detail
{
    [CppRefPath("<nn/audio/detail/audio_AudioInTypesInternal.h>")]
    public struct AudioInParameterInternal
    {
        public int32_t sampleRate;
        public int32_t channelCount;
        public int32_t sampleFormat;
        public int32_t state;
    }

    [CppRefPath(@"<nn/audio/detail/audio_IAudioIn.h>")]
    interface IAudioIn : IServiceObject
    {
        [MethodId(0)]
        Result GetAudioInState(Out<uint32_t> outAudioIn);

        [MethodId(1)]
        Result Start();

        [MethodId(2)]
        Result Stop();

        [MethodId(3)]
        Result AppendAudioInBuffer(InBuffer outAudioInBuffer, uint64_t outBufferClientPtr);

        // This event will be signaled when there are released buffers to retrieve.
        [MethodId(4)]
        Result RegisterBufferEvent(Out<NativeHandle> bufferEvent);

        // Return all released buffers in a single call.
        [MethodId(5)]
        Result GetReleasedAudioInBuffers(OutBuffer outAudioBuffer, Out<int> count);

        [MethodId(6)]
        Result ContainsAudioInBuffer(uint64_t audioBufferPointer, Out<bool> contains);

        [MethodId(7)]
        Result AppendUacInBuffer(InBuffer outAudioInBuffer, uint64_t outBufferClientPtr, NativeHandle inBufferHandle);

        [MethodId(8)]
        Result AppendAudioInBufferAuto([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]InBuffer outAudioInBuffer,
                                        uint64_t outBufferClientPtr);

        [MethodId(9)]
        Result GetReleasedAudioInBuffersAuto([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]OutBuffer outAudioBuffer,
                                            Out<int> count);

        [MethodId(10)]
        Result AppendUacInBufferAuto([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]InBuffer outAudioInBuffer,
                                    uint64_t outBufferClientPtr,
                                    NativeHandle inBufferHandle);

        [MethodId(11)]
        Result GetAudioInBufferCount(Out<int> count);

        [MethodId(12)]
        Result SetDeviceGain(float gain);

        [MethodId(13)]
        Result GetDeviceGain(Out<float> gain);
    }

    [CppRefPath(@"<nn/audio/detail/audio_IAudioInManager.h>")]
    interface IAudioInManager : IServiceObject
    {
        [MethodId(0)]
        Result ListAudioIns(OutBuffer outAudioIn, Out<int> amountRet);

        // If the name is "", then it is the default output.
        // If sampleRate is 0, then it is the default sample rate.
        [MethodId(1)]
        Result OpenAudioIn(Out<IAudioIn> outAudioIn, InBuffer nameIn, nn.audio.AudioInParameter param, NativeHandle processHandle, Out<nn.audio.detail.AudioInParameterInternal> audioOutInter, OutBuffer nameOut, nn.applet.CheckedAppletResourceUserId appletId);

        [MethodId(2)]
        Result ListAudioInsAuto([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]OutBuffer outAudioIn,
                                Out<int> amountRet);

        [MethodId(3)]
        Result OpenAudioInAuto(Out<IAudioIn> outAudioIn,
                            [Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]InBuffer nameIn,
                            nn.audio.AudioInParameter param,
                            NativeHandle processHandle,
                            Out<nn.audio.detail.AudioInParameterInternal> audioOutInter,
                            [Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]OutBuffer nameOut,
                            nn.applet.CheckedAppletResourceUserId appletId);

        [MethodId(4)]
        Result ListAudioInsAutoFiltered([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]OutBuffer outAudioIn,
                                Out<int> amountRet);

        [MethodId(5)]
        Result OpenAudioInProtocolSpecified(uint64_t protocolVersion, Out<IAudioIn> outAudioIn, InBuffer nameIn, nn.audio.AudioInParameter param, NativeHandle processHandle, Out<nn.audio.detail.AudioInParameterInternal> audioOutInter, OutBuffer nameOut, nn.applet.CheckedAppletResourceUserId appletId);
    }

    [CppRefPath(@"<nn/audio/detail/audio_IAudioInManagerForApplet.h>")]
    interface IAudioInManagerForApplet : IServiceObject
    {
        [MethodId(0)]
        Result RequestSuspend(nn.applet.AppletResourceUserId id, int64_t fadeTimeNanoSeconds);

        [MethodId(1)]
        Result RequestResume(nn.applet.AppletResourceUserId id, int64_t fadeTimeNanoSeconds);

        [MethodId(2)]
        Result GetProcessMasterVolume(Out<float> pOutVolume, nn.applet.AppletResourceUserId id);

        [MethodId(3)]
        Result SetProcessMasterVolume(nn.applet.AppletResourceUserId id, float volume, int64_t fadeTimeNanoSeconds);
    }

    [CppRefPath(@"<nn/audio/detail/audio_IAudioInManagerForDebugger.h>")]
    interface IAudioInManagerForDebugger : IServiceObject
    {
        [MethodId(0)]
        Result RequestSuspend(nn.applet.AppletResourceUserId id);

        [MethodId(1)]
        Result RequestResume(nn.applet.AppletResourceUserId id);
    }
}

