﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nne/audio/audio.h>

namespace nn {
namespace audio {

class AudioOutClientImplByHorizon
{
public:
    Result Initialize(const char* name) NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;
    int GetSampleRate() const NN_NOEXCEPT;
    int GetChannelCount() const NN_NOEXCEPT;
    int GetBitsPerSample() const NN_NOEXCEPT;
    void Wait() NN_NOEXCEPT;
    void* AcquireBuffer(int sampleCount) NN_NOEXCEPT;
    void ReleaseBuffer(int sampleCount) NN_NOEXCEPT;

private:
    int m_SampleRate;
    int m_ChannelCount;
    int m_BitsPerSample;

    nne::audio::gmix::Session* m_pAudioOut;
    nne::audio::device::Session* m_pDevice;

    int8_t* m_pBuffer;
    int8_t m_WriteBuffer[1024]; // TODO: complete hack...

    size_t m_bufferReadPosition;
    size_t m_bufferWritePosition;
    size_t m_bufferWritten;
    size_t m_bufferSize;
};

typedef AudioOutClientImplByHorizon AudioOutClientImpl;

}  // namespace audio
}  // namespace nn
