﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/audio/audio_AudioOutTypes.h>
#include "../audio_AudioInManagerImpl.h"
#include "../audio_AudioSession.h"
#include "audio_AudioWasapiDriver.h"

namespace nn {
namespace audio {

namespace server {
int ListAudioIns(AudioInInfo* outAudioIns, int count, bool filtered) NN_NOEXCEPT;
void AudioInInitialize(nn::os::SemaphoreType* semaphore, nn::os::EventType* pEventSemaphore) NN_NOEXCEPT;
void AudioInFinalize() NN_NOEXCEPT;
} // namespace server

namespace detail {

class AudioInSession : public AudioSession<nn::audio::AudioInBufferCountMax, 4>
{
public:
    AudioInSession(int32_t sessionId, nn::os::SystemEvent& releaseClientBufferEvent) NN_NOEXCEPT;
    virtual ~AudioInSession() NN_NOEXCEPT;
    virtual const char* GetDefaultName() const NN_NOEXCEPT;
    virtual Result IsSupported(const char* name, const server::SessionFormat& format) const NN_NOEXCEPT;
    AudioInState GetState() const NN_NOEXCEPT;
    void SetAudioOutVolume(float volume) NN_NOEXCEPT;
    float GetAudioOutVolume() const NN_NOEXCEPT;

private:
    AudioDriver* GetDriver(int sessionId) const NN_NOEXCEPT;
    static AudioWasapiDriver s_WindowsDriver[server::AudioInManagerImpl::NumberOfAudioInSessions];
};

}  // namespace detail
}  // namespace audio
}  // namespace nn
