﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/audio/detail/audio_IAudioRendererManagerForApplet.h>

namespace nn { namespace audio { namespace server {

class AudioRendererManagerForAppletImpl
{
public:
    nn::Result RequestSuspend(const nn::applet::AppletResourceUserId& id, std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT;
    nn::Result RequestResume(const nn::applet::AppletResourceUserId& id, std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT;
    nn::Result GetProcessMasterVolume(nn::sf::Out<float> pOutVolume, const nn::applet::AppletResourceUserId& id) NN_NOEXCEPT;
    nn::Result SetProcessMasterVolume(const nn::applet::AppletResourceUserId& id, float volume, std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT;
    nn::Result RegisterAppletResourceUserId(nn::applet::AppletResourceUserId id) NN_NOEXCEPT;
    nn::Result UnregisterAppletResourceUserId(nn::applet::AppletResourceUserId id) NN_NOEXCEPT;
    nn::Result GetProcessRecordVolume(nn::sf::Out<float> pOutVolume, const nn::applet::AppletResourceUserId& id) NN_NOEXCEPT;
    nn::Result SetProcessRecordVolume(const nn::applet::AppletResourceUserId& id, float volume, std::int64_t fadeTimeNanoSeconds) NN_NOEXCEPT;
};

}}}  // namespace nn::audio::server
