﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>

#if defined(NN_BUILD_CONFIG_OS_WIN32)
    #include "detail/audio_AudioOutClientImpl.win32.h"
#else
    #error "未サポートの OS 種別が指定されています。"
#endif

namespace nn { namespace audio { namespace server {

class AudioOutClient
{
public:
    Result Initialize(const char* name) NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;
    int GetSampleRate() const NN_NOEXCEPT;
    int GetChannelCount() const NN_NOEXCEPT;
    int GetBitsPerSample() const NN_NOEXCEPT;
    void Wait() NN_NOEXCEPT;
    void* AcquireBuffer(int sampleCount) NN_NOEXCEPT;
    void ReleaseBuffer(int sampleCount) NN_NOEXCEPT;
private:
    AudioOutClientImpl m_Impl;
};

}}}  // namespace nn::audio::server
