﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/lmem/lmem_ExpHeap.h>

#include <nn/sf/impl/sf_ExpHeapAllocator.h>

#include <nn/audio/detail/audio_IAudioDebugManager.h>


namespace nn { namespace audio { namespace server {

class AudioDebugManagerImpl : public nn::sf::ISharedObject
{
public:
    AudioDebugManagerImpl() NN_NOEXCEPT;
    virtual ~AudioDebugManagerImpl() NN_NOEXCEPT;
    nn::Result StartDspProfiler(nn::sf::NativeHandle processHandle, uint64_t bufferPtr, uint32_t bufferSize) NN_NOEXCEPT;
    nn::Result StopDspProfiler() NN_NOEXCEPT;
    nn::Result StartCpuProfiler() NN_NOEXCEPT;
    nn::Result StopCpuProfiler() NN_NOEXCEPT;

private:
    typedef nn::sf::ExpHeapAllocator MyAllocator;
    MyAllocator m_Allocator;
    static const int HeapBufferSize = 4 * 1024; // TODO: Review the heap usage
    std::aligned_storage<HeapBufferSize>::type m_HeapBuffer;
    nn::lmem::HeapHandle m_HeapHandle;
};

}}}  // namespace nn::audio::server
