﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <limits>
#include <nn/nn_Macro.h>

namespace nn { namespace audio { namespace dsp { namespace detail {

NN_FORCEINLINE void ApplyBiquadFilter(int32_t* output, const int32_t* input, const int16_t* numerator, const int16_t* denominator, int64_t* state, int sampleCount) NN_NOEXCEPT
{
    const int Q = 14;

    const auto b0 = numerator[0];
    const auto b1 = numerator[1];
    const auto b2 = numerator[2];
    const auto a1 = denominator[0];
    const auto a2 = denominator[1];

    auto s1 = state[0];
    auto s2 = state[1];

    for (int i = 0; i < sampleCount; ++i)
    {
        auto x = input[i];
        auto t = (static_cast<int64_t>(x) * b0 + s1 + (1 << (Q - 1))) >> Q;
        t = t < std::numeric_limits<int32_t>::max() ? t : std::numeric_limits<int32_t>::max();
        t = t > std::numeric_limits<int32_t>::min() ? t : std::numeric_limits<int32_t>::min();
        auto y = static_cast<int32_t>(t);
        s1 = static_cast<int64_t>(x) * b1 + static_cast<int64_t>(y) * a1 + s2;
        s2 = static_cast<int64_t>(x) * b2 + static_cast<int64_t>(y) * a2;
        output[i] = y;
    }

    state[0] = s1;
    state[1] = s2;
}

}}}}  // namespace nn::audio::dsp::detail
