﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../audio_AddrTypes.h" // DspAddr
#include "../common/audio_AudioRendererSession.h"
#include "audio_MailBoxIds.h"

namespace nn { namespace audio {

const int32_t  NX_AUDIO_DSP_BUFFERSIZE = 384 * 1024;

enum RpcMapMessages : int32_t
{
    NX_AUDIO_DSP_RPC_MAP_ADDRESS     = 1,
    NX_AUDIO_DSP_RPC_MAP_ADDRESS_ACK = 2,
    NX_AUDIO_DSP_RPC_UNMAP_ADDRESS     = 3,
    NX_AUDIO_DSP_RPC_UNMAP_ADDRESS_ACK = 4,
    NX_AUDIO_DSP_RPC_INVALIDATE_CACHE = 5,
    NX_AUDIO_DSP_RPC_INVALIDATE_CACHE_ACK = 6,
    NX_AUDIO_DSP_RPC_QUIT = 7,
    NX_AUDIO_DSP_RPC_QUIT_ACK = 8,
};

enum RpcProfilerMessages : int32_t
{
    NX_AUDIO_DSP_RPC_ENABLE_PROFILER = 0,
    NX_AUDIO_DSP_RPC_ENABLE_PROFILER_ACK,
    NX_AUDIO_DSP_RPC_DISABLE_PROFILER,
    NX_AUDIO_DSP_RPC_DISABLE_PROFILER_ACK,
};

enum AudioRendererMessages : int32_t
{
    NX_AUDIO_DSP_MSG_RENDER_BOOT  = 22,
    NX_AUDIO_DSP_MSG_RENDER_END   = 32,
    NX_AUDIO_DSP_MSG_RENDER_BEGIN = 42,
    NX_AUDIO_DSP_MSG_RENDER_QUIT  = 52,
};

typedef struct RpcData
{
    uint32_t arg[8];
} RpcData_t;

struct RendererDspSharedContext
{
    DspAddr commandListAddr;
    uint32_t commandListSize;
    uint32_t avaliableProcessingTimePerAudioFrame;
    uint32_t remainCommandCount;
    bool isNew;
    uint64_t clientId;
    uint32_t renderingStartLatency;
};

typedef struct SharedMem
{
    RendererDspSharedContext rendererDspSharedContexts[common::AudioRendererSessionCountMax];
    RpcData_t rpcData;
} SharedMem_t;

}} // namespace nn { namespace audio {
