﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_MessageQueue.h>

namespace nn { namespace audio { namespace dsp {

class MailBoxImplByMessageQueue
{
protected:
    static const int InvalidMailBoxIndex = -1;
    static const int InvalidMailBoxId = -1;
    static const int MailBoxCount = 4;
    static const int MessageQueueCount = MailBoxCount * 2;
    static uintptr_t g_MessageQueueBuffer[MessageQueueCount];
    static nn::os::MessageQueueType g_MessageQueues[MessageQueueCount];
    static int g_IdMap[MailBoxCount];
    int m_SenderId;
    int m_ReceiverId;
    int m_MailBoxIndex;
public:
    static void Initialize() NN_NOEXCEPT;
    static void Finalize() NN_NOEXCEPT;
    void Open(int id, bool isServer) NN_NOEXCEPT;
    void Close() NN_NOEXCEPT;
    void Send(int32_t message) NN_NOEXCEPT;
    int32_t Recv() NN_NOEXCEPT;
};

typedef MailBoxImplByMessageQueue MailBoxImpl;

}}}  // namespace nn::audio::dsp

