﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace audio {

// TODO: insert generation codes here as a comment block.

// Table for the q14 pow10 function which assumed input range [0.0 to -5.3] normalized to [0 to 255].
#define QF30_UINT(x) ( static_cast<uint32_t>( (x) * ( 1 << 30)) )

#define POW10TABLE \
        QF30_UINT(1.0000000000), /* -x------ -------- -------- -------- == (pow(10.0,-0.00000) == 1.0000000000) * 1<<30   #0 */ \
        QF30_UINT(0.9532694744), /* --xxxx-x ------x- -x-+++-+ +++++--- == (pow(10.0,-0.02078) == 0.9532694744) * 1<<30   #1 */ \
        QF30_UINT(0.9087226909), /* --xxx-x- --x-x--- x-----++ --+++--- == (pow(10.0,-0.04157) == 0.9087226909) * 1<<30   #2 */ \
        QF30_UINT(0.8662576019), /* --xx-xxx -xxx---- xx----++ +-+++-+- == (pow(10.0,-0.06235) == 0.8662576019) * 1<<30   #3 */ \
        QF30_UINT(0.8257769289), /* --xx-x-- xx-xx--x x----+++ -++++-+- == (pow(10.0,-0.08314) == 0.8257769289) * 1<<30   #4 */ \
        QF30_UINT(0.7871879390), /* --xx--x- -xx----x -x--+--+ +----+-+ == (pow(10.0,-0.10392) == 0.7871879390) * 1<<30   #5 */ \
        QF30_UINT(0.7504022329), /* --xx---- -----xx- x--+-+++ ---+-++- == (pow(10.0,-0.12471) == 0.7504022329) * 1<<30   #6 */ \
        QF30_UINT(0.7153355421), /* --x-xx-x xx--x--- ----+++- +-+++-+- == (pow(10.0,-0.14549) == 0.7153355421) * 1<<30   #7 */ \
        QF30_UINT(0.6819075363), /* --x-x-xx x-x--x-- -x-+++++ +-----+- == (pow(10.0,-0.16627) == 0.6819075363) * 1<<30   #8 */ \
        QF30_UINT(0.6500416387), /* --x-x--x x--xx-x- -x--+--- --++++++ == (pow(10.0,-0.18706) == 0.6500416387) * 1<<30   #9 */ \
        QF30_UINT(0.6196648513), /* --x--xxx x-x-x--- x--+-++- ++---+-- == (pow(10.0,-0.20784) == 0.6196648513) * 1<<30   #10 */ \
        QF30_UINT(0.5907075871), /* --x--x-x xx--xxx- --+--+++ --++--+- == (pow(10.0,-0.22863) == 0.5907075871) * 1<<30   #11 */ \
        QF30_UINT(0.5631035111), /* --x--x-- ----x--x xx+---++ -+--++++ == (pow(10.0,-0.24941) == 0.5631035111) * 1<<30   #12 */ \
        QF30_UINT(0.5367893881), /* --x---x- -x-xx-x- xx-----+ +++----+ == (pow(10.0,-0.27020) == 0.5367893881) * 1<<30   #13 */ \
        QF30_UINT(0.5117049378), /* --x----- x-xxxxxx xx---++- ---+---+ == (pow(10.0,-0.29098) == 0.5117049378) * 1<<30   #14 */ \
        QF30_UINT(0.4877926972), /* ---xxxxx --xx-xxx xx+++++- ++-+++-- == (pow(10.0,-0.31176) == 0.4877926972) * 1<<30   #15 */ \
        QF30_UINT(0.4649978880), /* ---xxx-x xx----x- x----++- +------- == (pow(10.0,-0.33255) == 0.4649978880) * 1<<30   #16 */ \
        QF30_UINT(0.4432682923), /* ---xxx-- -x-xxxx- x------+ +++++--+ == (pow(10.0,-0.35333) == 0.4432682923) * 1<<30   #17 */ \
        QF30_UINT(0.4225541321), /* ---xx-xx ----x-xx --+----- -+++++-+ == (pow(10.0,-0.37412) == 0.4225541321) * 1<<30   #18 */ \
        QF30_UINT(0.4028079554), /* ---xx--x xx---xxx x--++-++ -----+-+ == (pow(10.0,-0.39490) == 0.4028079554) * 1<<30   #19 */ \
        QF30_UINT(0.3839845279), /* ---xx--- x--x--xx --++--++ ++-+-+++ == (pow(10.0,-0.41569) == 0.3839845279) * 1<<30   #20 */ \
        QF30_UINT(0.3660407291), /* ---x-xxx -xx-xx-x --++-++- ---++--- == (pow(10.0,-0.43647) == 0.3660407291) * 1<<30   #21 */ \
        QF30_UINT(0.3489354535), /* ---x-xx- -x-x-x-- xx++-+-+ -+-++++- == (pow(10.0,-0.45725) == 0.3489354535) * 1<<30   #22 */ \
        QF30_UINT(0.3326295163), /* ---x-x-x -x--x--x xx--++-+ -+-+---- == (pow(10.0,-0.47804) == 0.3326295163) * 1<<30   #23 */ \
        QF30_UINT(0.3170855642), /* ---x-x-- -x--x-xx --+----+ -+------ == (pow(10.0,-0.49882) == 0.3170855642) * 1<<30   #24 */ \
        QF30_UINT(0.3022679891), /* ---x--xx -x-xx--- -x-++-++ ++-+-++- == (pow(10.0,-0.51961) == 0.3022679891) * 1<<30   #25 */ \
        QF30_UINT(0.2881428472), /* ---x--x- -xxx---- xx+-+++- +-++--+- == (pow(10.0,-0.54039) == 0.2881428472) * 1<<30   #26 */ \
        QF30_UINT(0.2746777805), /* ---x---x x--x-x-- -x-+--+- ---+++-+ == (pow(10.0,-0.56118) == 0.2746777805) * 1<<30   #27 */ \
        QF30_UINT(0.2618419434), /* ---x---- xx----x- -----+-- +-++-++- == (pow(10.0,-0.58196) == 0.2618419434) * 1<<30   #28 */ \
        QF30_UINT(0.2496059318), /* ----xxxx xxxxx--x x---+-++ --+-+--- == (pow(10.0,-0.60275) == 0.2496059318) * 1<<30   #29 */ \
        QF30_UINT(0.2379417154), /* ----xxxx --xxx-x- -x+-++++ +++--+-- == (pow(10.0,-0.62353) == 0.2379417154) * 1<<30   #30 */ \
        QF30_UINT(0.2268225740), /* ----xxx- x----x-- -x----+- ++-+-+-- == (pow(10.0,-0.64431) == 0.2268225740) * 1<<30   #31 */ \
        QF30_UINT(0.2162230359), /* ----xx-x xx-x-xx- x--++--+ --+--+-+ == (pow(10.0,-0.66510) == 0.2162230359) * 1<<30   #32 */ \
        QF30_UINT(0.2061188198), /* ----xx-x --xx---x ----++-- +++++++- == (pow(10.0,-0.68588) == 0.2061188198) * 1<<30   #33 */ \
        QF30_UINT(0.1964867790), /* ----xx-- x--x--xx --++++-+ -+--+--- == (pow(10.0,-0.70667) == 0.1964867790) * 1<<30   #34 */ \
        QF30_UINT(0.1873048485), /* ----x-xx xxxxxx-- xx--++-+ -++++-+- == (pow(10.0,-0.72745) == 0.1873048485) * 1<<30   #35 */ \
        QF30_UINT(0.1785519945), /* ----x-xx -xx-xx-x -x+--+-+ -+-++--- == (pow(10.0,-0.74824) == 0.1785519945) * 1<<30   #36 */ \
        QF30_UINT(0.1702081660), /* ----x-x- xxx--x-- x-++---- ++--+-++ == (pow(10.0,-0.76902) == 0.1702081660) * 1<<30   #37 */ \
        QF30_UINT(0.1622542489), /* ----x-x- -xx---x- -x-+++++ +-+--+-+ == (pow(10.0,-0.78980) == 0.1622542489) * 1<<30   #38 */ \
        QF30_UINT(0.1546720226), /* ----x--x xxx--xx- --+--+-+ -+++++-- == (pow(10.0,-0.81059) == 0.1546720226) * 1<<30   #39 */ \
        QF30_UINT(0.1474441177), /* ----x--x -xx-xxxx x-+++--+ -+++-+-- == (pow(10.0,-0.83137) == 0.1474441177) * 1<<30   #40 */ \
        QF30_UINT(0.1405539766), /* ----x--- xxxxxxx- xx-+-++- ---++-++ == (pow(10.0,-0.85216) == 0.1405539766) * 1<<30   #41 */ \
        QF30_UINT(0.1339858154), /* ----x--- x--x--xx --+++--+ --+++++- == (pow(10.0,-0.87294) == 0.1339858154) * 1<<30   #42 */ \
        QF30_UINT(0.1277245878), /* ----x--- --x-xx-- x-+---++ ++------ == (pow(10.0,-0.89373) == 0.1277245878) * 1<<30   #43 */ \
        QF30_UINT(0.1217559507), /* -----xxx xx--x-x- xx-++--+ -++++--+ == (pow(10.0,-0.91451) == 0.1217559507) * 1<<30   #44 */ \
        QF30_UINT(0.1160662311), /* -----xxx -xx-xx-x x-+----+ ----++++ == (pow(10.0,-0.93529) == 0.1160662311) * 1<<30   #45 */ \
        QF30_UINT(0.1106423951), /* -----xxx ---x-x-- xx----++ ++-+-+++ == (pow(10.0,-0.95608) == 0.1106423951) * 1<<30   #46 */ \
        QF30_UINT(0.1054720179), /* -----xx- xx------ ----++-+ +-++-+-+ == (pow(10.0,-0.97686) == 0.1054720179) * 1<<30   #47 */ \
        QF30_UINT(0.1005432550), /* -----xx- -xx-xxxx -x--++-- +++++-+- == (pow(10.0,-0.99765) == 0.1005432550) * 1<<30   #48 */ \
        QF30_UINT(0.0958448159), /* -----xx- --x---x- -x-+--+- -+--+-++ == (pow(10.0,-1.01843) == 0.0958448159) * 1<<30   #49 */ \
        QF30_UINT(0.0913659373), /* -----x-x xx-xx--- xx++---- +----+-- == (pow(10.0,-1.03922) == 0.0913659373) * 1<<30   #50 */ \
        QF30_UINT(0.0870963590), /* -----x-x x--x--x- xx++++-- +--++-++ == (pow(10.0,-1.06000) == 0.0870963590) * 1<<30   #51 */ \
        QF30_UINT(0.0830263004), /* -----x-x -x-x---- -x--++-+ +---+-++ == (pow(10.0,-1.08078) == 0.0830263004) * 1<<30   #52 */ \
        QF30_UINT(0.0791464377), /* -----x-x ---x---- x-++++-- --+++--- == (pow(10.0,-1.10157) == 0.0791464377) * 1<<30   #53 */ \
        QF30_UINT(0.0754478831), /* -----x-- xx-x-x-- --+---++ -+-+++-- == (pow(10.0,-1.12235) == 0.0754478831) * 1<<30   #54 */ \
        QF30_UINT(0.0719221638), /* -----x-- x--xx-x- -x-+++++ -++-+-++ == (pow(10.0,-1.14314) == 0.0719221638) * 1<<30   #55 */ \
        QF30_UINT(0.0685612033), /* -----x-- -xx---xx -x--+++- +---+--- == (pow(10.0,-1.16392) == 0.0685612033) * 1<<30   #56 */ \
        QF30_UINT(0.0653573023), /* -----x-- --x-xxx- xx-+---- -++--+-+ == (pow(10.0,-1.18471) == 0.0653573023) * 1<<30   #57 */ \
        QF30_UINT(0.0623031212), /* ------xx xxxxxx-- xx---++- --+++-++ == (pow(10.0,-1.20549) == 0.0623031212) * 1<<30   #58 */ \
        QF30_UINT(0.0593916636), /* ------xx xx--xx-x ---+--+- +-++---+ == (pow(10.0,-1.22627) == 0.0593916636) * 1<<30   #59 */ \
        QF30_UINT(0.0566162599), /* ------xx x--xxxxx x--++--+ ++--+++- == (pow(10.0,-1.24706) == 0.0566162599) * 1<<30   #60 */ \
        QF30_UINT(0.0539705523), /* ------xx -xxx-x-- -x------ +++--+++ == (pow(10.0,-1.26784) == 0.0539705523) * 1<<30   #61 */ \
        QF30_UINT(0.0514484801), /* ------xx -x--x-x- xx+-+++- +--+---+ == (pow(10.0,-1.28863) == 0.0514484801) * 1<<30   #62 */ \
        QF30_UINT(0.0490442656), /* ------xx --x---xx x---+-+- +---++++ == (pow(10.0,-1.30941) == 0.0490442656) * 1<<30   #63 */ \
        QF30_UINT(0.0467524012), /* ------x- xxxxxx-x xx++++-+ ++--+--+ == (pow(10.0,-1.33020) == 0.0467524012) * 1<<30   #64 */ \
        QF30_UINT(0.0445676370), /* ------x- xx-xx-x- --++--+- --+++--- == (pow(10.0,-1.35098) == 0.0445676370) * 1<<30   #65 */ \
        QF30_UINT(0.0424849679), /* ------x- x-xxx--- ---+--+- ++-+++++ == (pow(10.0,-1.37176) == 0.0424849679) * 1<<30   #66 */ \
        QF30_UINT(0.0404996230), /* ------x- x--x-xxx x---+-++ +-+++-++ == (pow(10.0,-1.39255) == 0.0404996230) * 1<<30   #67 */ \
        QF30_UINT(0.0386070543), /* ------x- -xxxx--- x---+--+ +-+++--+ == (pow(10.0,-1.41333) == 0.0386070543) * 1<<30   #68 */ \
        QF30_UINT(0.0368029264), /* ------x- -x-xx-x- xx+++-+- +-+-+--+ == (pow(10.0,-1.43412) == 0.0368029264) * 1<<30   #69 */ \
        QF30_UINT(0.0350831063), /* ------x- --xxxxx- xx--++-+ --++-+++ == (pow(10.0,-1.45490) == 0.0350831063) * 1<<30   #70 */ \
        QF30_UINT(0.0334436543), /* ------x- --x---xx xx++---- ++-++-+- == (pow(10.0,-1.47569) == 0.0334436543) * 1<<30   #71 */ \
        QF30_UINT(0.0318808148), /* ------x- ----x-x- -x-+-+-+ ++-+-+-- == (pow(10.0,-1.49647) == 0.0318808148) * 1<<30   #72 */ \
        QF30_UINT(0.0303910075), /* -------x xxxx---x xx+-++-+ --+----- == (pow(10.0,-1.51725) == 0.0303910075) * 1<<30   #73 */ \
        QF30_UINT(0.0289708198), /* -------x xx-xx-x- x-+-+--- -++-++-+ == (pow(10.0,-1.53804) == 0.0289708198) * 1<<30   #74 */ \
        QF30_UINT(0.0276169981), /* -------x xx---x-- -x+++-+- ---+-++- == (pow(10.0,-1.55882) == 0.0276169981) * 1<<30   #75 */ \
        QF30_UINT(0.0263264413), /* -------x x-x-xxxx -x-+-+-+ ---++--+ == (pow(10.0,-1.57961) == 0.0263264413) * 1<<30   #76 */ \
        QF30_UINT(0.0250961929), /* -------x x--xx-xx --+-++-+ ---+---- == (pow(10.0,-1.60039) == 0.0250961929) * 1<<30   #77 */ \
        QF30_UINT(0.0239234346), /* -------x x----xxx xx++-++- --+-+--- == (pow(10.0,-1.62118) == 0.0239234346) * 1<<30   #78 */ \
        QF30_UINT(0.0228054799), /* -------x -xxx-x-x x-+--+-+ ---++++- == (pow(10.0,-1.64196) == 0.0228054799) * 1<<30   #79 */ \
        QF30_UINT(0.0217397678), /* -------x -xx--x-- --+-++++ --++--+- == (pow(10.0,-1.66275) == 0.0217397678) * 1<<30   #80 */ \
        QF30_UINT(0.0207238571), /* -------x -x-x--xx x---+-+- --+-+--- == (pow(10.0,-1.68353) == 0.0207238571) * 1<<30   #81 */ \
        QF30_UINT(0.0197554203), /* -------x -x----xx x-+-++-- --++++-+ == (pow(10.0,-1.70431) == 0.0197554203) * 1<<30   #82 */ \
        QF30_UINT(0.0188322392), /* -------x --xx-x-- x---++-- --+---++ == (pow(10.0,-1.72510) == 0.0188322392) * 1<<30   #83 */ \
        QF30_UINT(0.0179521987), /* -------x --x--xx- --+----- +++++-++ == (pow(10.0,-1.74588) == 0.0179521987) * 1<<30   #84 */ \
        QF30_UINT(0.0171132830), /* -------x ---xx--- -x+---+- -+-+---- == (pow(10.0,-1.76667) == 0.0171132830) * 1<<30   #85 */ \
        QF30_UINT(0.0163135703), /* -------x ----x-xx -x--+--- ---+--++ == (pow(10.0,-1.78745) == 0.0163135703) * 1<<30   #86 */ \
        QF30_UINT(0.0155512286), /* -------- xxxxxxx- xx--+-+- +--+-+-+ == (pow(10.0,-1.80824) == 0.0155512286) * 1<<30   #87 */ \
        QF30_UINT(0.0148245115), /* -------- xxxx--x- xx+---+- +-----+- == (pow(10.0,-1.82902) == 0.0148245115) * 1<<30   #88 */ \
        QF30_UINT(0.0141317543), /* -------- xxx--xxx x---+--- +++----- == (pow(10.0,-1.84980) == 0.0141317543) * 1<<30   #89 */ \
        QF30_UINT(0.0134713700), /* -------- xx-xxx-- x-++-+++ -----+-+ == (pow(10.0,-1.87059) == 0.0134713700) * 1<<30   #90 */ \
        QF30_UINT(0.0128418458), /* -------- xx-x--x- -x+--++- +--++-++ == (pow(10.0,-1.89137) == 0.0128418458) * 1<<30   #91 */ \
        QF30_UINT(0.0122417396), /* -------- xx--x--- x--+---+ +--+-+-- == (pow(10.0,-1.91216) == 0.0122417396) * 1<<30   #92 */ \
        QF30_UINT(0.0116696767), /* -------- x-xxxxxx --++--+- --+-++-- == (pow(10.0,-1.93294) == 0.0116696767) * 1<<30   #93 */ \
        QF30_UINT(0.0111243466), /* -------- x-xx-xx- -x----+- +++--+-- == (pow(10.0,-1.95373) == 0.0111243466) * 1<<30   #94 */ \
        QF30_UINT(0.0106045000), /* -------- x-x-xx-x x-+++++- -+++++++ == (pow(10.0,-1.97451) == 0.0106045000) * 1<<30   #95 */ \
        QF30_UINT(0.0101089461), /* -------- x-x--x-x x--+++++ +++++++- == (pow(10.0,-1.99529) == 0.0101089461) * 1<<30   #96 */ \
        QF30_UINT(0.0096365498), /* -------- x--xxx-x xx+---+- +--+++++ == (pow(10.0,-2.01608) == 0.0096365498) * 1<<30   #97 */ \
        QF30_UINT(0.0091862287), /* -------- x--x-xx- x------+ ++-+-++- == (pow(10.0,-2.03686) == 0.0091862287) * 1<<30   #98 */ \
        QF30_UINT(0.0087569514), /* -------- x---xxxx -x+++--+ -+-+---+ == (pow(10.0,-2.05765) == 0.0087569514) * 1<<30   #99 */ \
        QF30_UINT(0.0083477345), /* -------- x---x--- xx---+-- ++++---- == (pow(10.0,-2.07843) == 0.0083477345) * 1<<30   #100 */ \
        QF30_UINT(0.0079576405), /* -------- x-----x- -x+----- ++----++ == (pow(10.0,-2.09922) == 0.0079576405) * 1<<30   #101 */ \
        QF30_UINT(0.0075857758), /* -------- -xxxxx-- -x--+--+ ----++-+ == (pow(10.0,-2.12000) == 0.0075857758) * 1<<30   #102 */ \
        QF30_UINT(0.0072312885), /* -------- -xxx-xx- -x+++-+- --+++--+ == (pow(10.0,-2.14078) == 0.0072312885) * 1<<30   #103 */ \
        QF30_UINT(0.0068933666), /* -------- -xxx---- xx++---- +++----- == (pow(10.0,-2.16157) == 0.0068933666) * 1<<30   #104 */ \
        QF30_UINT(0.0065712359), /* -------- -xx-x-xx x-+-+--+ ++----++ == (pow(10.0,-2.18235) == 0.0065712359) * 1<<30   #105 */ \
        QF30_UINT(0.0062641586), /* -------- -xx--xx- x-+----+ ++--+--+ == (pow(10.0,-2.20314) == 0.0062641586) * 1<<30   #106 */ \
        QF30_UINT(0.0059714312), /* -------- -xx----x xx-+-+-+ ++++++++ == (pow(10.0,-2.22392) == 0.0059714312) * 1<<30   #107 */ \
        QF30_UINT(0.0056923831), /* -------- -x-xxx-x -x----++ +--+-++- == (pow(10.0,-2.24471) == 0.0056923831) * 1<<30   #108 */ \
        QF30_UINT(0.0054263750), /* -------- -x-xx--- xx+--+++ ++-++++- == (pow(10.0,-2.26549) == 0.0054263750) * 1<<30   #109 */ \
        QF30_UINT(0.0051727977), /* -------- -x-x-x-- xx------ -+--+--+ == (pow(10.0,-2.28627) == 0.0051727977) * 1<<30   #110 */ \
        QF30_UINT(0.0049310701), /* -------- -x-x---- xx--+-+- -++-+--- == (pow(10.0,-2.30706) == 0.0049310701) * 1<<30   #111 */ \
        QF30_UINT(0.0047006386), /* -------- -x--xx-x ------++ +++-+--- == (pow(10.0,-2.32784) == 0.0047006386) * 1<<30   #112 */ \
        QF30_UINT(0.0044809753), /* -------- -x--x--x -x+-+-+- +--+--++ == (pow(10.0,-2.34863) == 0.0044809753) * 1<<30   #113 */ \
        QF30_UINT(0.0042715770), /* -------- -x---x-x xx++++-- -+--+-++ == (pow(10.0,-2.36941) == 0.0042715770) * 1<<30   #114 */ \
        QF30_UINT(0.0040719639), /* -------- -x----x- x-++-+++ ----+++- == (pow(10.0,-2.39020) == 0.0040719639) * 1<<30   #115 */ \
        QF30_UINT(0.0038816789), /* -------- --xxxxxx x--++--- ++++---+ == (pow(10.0,-2.41098) == 0.0038816789) * 1<<30   #116 */ \
        QF30_UINT(0.0037002860), /* -------- --xxxx-- x-+----- --+----- == (pow(10.0,-2.43176) == 0.0037002860) * 1<<30   #117 */ \
        QF30_UINT(0.0035273697), /* -------- --xxx--x xx--+-+- ++-+++-- == (pow(10.0,-2.45255) == 0.0035273697) * 1<<30   #118 */ \
        QF30_UINT(0.0033625339), /* -------- --xx-xxx ---+-+++ -+++++-+ == (pow(10.0,-2.47333) == 0.0033625339) * 1<<30   #119 */ \
        QF30_UINT(0.0032054009), /* -------- --xx-x-- x----+-- -++-++-+ == (pow(10.0,-2.49412) == 0.0032054009) * 1<<30   #120 */ \
        QF30_UINT(0.0030556108), /* -------- --xx--x- ---+---- --+-+--+ == (pow(10.0,-2.51490) == 0.0030556108) * 1<<30   #121 */ \
        QF30_UINT(0.0029128205), /* -------- --x-xxxx x-+++--+ -+-----+ == (pow(10.0,-2.53569) == 0.0029128205) * 1<<30   #122 */ \
        QF30_UINT(0.0027767029), /* -------- --x-xx-x -x+++++- -+-+-++- == (pow(10.0,-2.55647) == 0.0027767029) * 1<<30   #123 */ \
        QF30_UINT(0.0026469461), /* -------- --x-x-xx -x-++++- ---++--+ == (pow(10.0,-2.57725) == 0.0026469461) * 1<<30   #124 */ \
        QF30_UINT(0.0025232529), /* -------- --x-x--x -x-+-+++ -+--+-+- == (pow(10.0,-2.59804) == 0.0025232529) * 1<<30   #125 */ \
        QF30_UINT(0.0024053400), /* -------- --x--xxx -x+-+--- +-+++-+- == (pow(10.0,-2.61882) == 0.0024053400) * 1<<30   #126 */ \
        QF30_UINT(0.0022929372), /* -------- --x--x-x x--+---+ -+---+++ == (pow(10.0,-2.63961) == 0.0022929372) * 1<<30   #127 */ \
        QF30_UINT(0.0021857870), /* -------- --x---xx xx--++++ ++-++-++ == (pow(10.0,-2.66039) == 0.0021857870) * 1<<30   #128 */ \
        QF30_UINT(0.0020836440), /* -------- --x---x- --+---++ -+++---- == (pow(10.0,-2.68118) == 0.0020836440) * 1<<30   #129 */ \
        QF30_UINT(0.0019862743), /* -------- --x----- x---+-++ ----+-+- == (pow(10.0,-2.70196) == 0.0019862743) * 1<<30   #130 */ \
        QF30_UINT(0.0018934546), /* -------- ---xxxxx -----+-+ +-+++--+ == (pow(10.0,-2.72275) == 0.0018934546) * 1<<30   #131 */ \
        QF30_UINT(0.0018049725), /* -------- ---xxx-x x--+--+- +--++-+- == (pow(10.0,-2.74353) == 0.0018049725) * 1<<30   #132 */ \
        QF30_UINT(0.0017206252), /* -------- ---xxx-- --++---- ++-+--++ == (pow(10.0,-2.76431) == 0.0017206252) * 1<<30   #133 */ \
        QF30_UINT(0.0016402195), /* -------- ---xx-x- xx-+++++ +--+-+-- == (pow(10.0,-2.78510) == 0.0016402195) * 1<<30   #134 */ \
        QF30_UINT(0.0015635711), /* -------- ---xx--x x--++++- ---++--- == (pow(10.0,-2.80588) == 0.0015635711) * 1<<30   #135 */ \
        QF30_UINT(0.0014905046), /* -------- ---xx--- -x+-+-++ +-+----+ == (pow(10.0,-2.82667) == 0.0014905046) * 1<<30   #136 */ \
        QF30_UINT(0.0014208526), /* -------- ---x-xxx -x---+++ -+++++-+ == (pow(10.0,-2.84745) == 0.0014208526) * 1<<30   #137 */ \
        QF30_UINT(0.0013544554), /* -------- ---x-xx- --++---- ++++++++ == (pow(10.0,-2.86824) == 0.0013544554) * 1<<30   #138 */ \
        QF30_UINT(0.0012911610), /* -------- ---x-x-x --+--+++ +----++- == (pow(10.0,-2.88902) == 0.0012911610) * 1<<30   #139 */ \
        QF30_UINT(0.0012308243), /* -------- ---x-x-- --+-+-+- -+++-+-- == (pow(10.0,-2.90980) == 0.0012308243) * 1<<30   #140 */ \
        QF30_UINT(0.0011733073), /* -------- ---x--xx --+++--+ --++-+-+ == (pow(10.0,-2.93059) == 0.0011733073) * 1<<30   #141 */ \
        QF30_UINT(0.0011184780), /* -------- ---x--x- -x-+--++ --++++-+ == (pow(10.0,-2.95137) == 0.0011184780) * 1<<30   #142 */ \
        QF30_UINT(0.0010662109), /* -------- ---x---x -x+++--- ------++ == (pow(10.0,-2.97216) == 0.0010662109) * 1<<30   #143 */ \
        QF30_UINT(0.0010163863), /* -------- ---x---- x-+--+++ ----+--+ == (pow(10.0,-2.99294) == 0.0010163863) * 1<<30   #144 */ \
        QF30_UINT(0.0009688901), /* -------- ----xxxx xx-+++++ ++-+--+- == (pow(10.0,-3.01373) == 0.0009688901) * 1<<30   #145 */ \
        QF30_UINT(0.0009236133), /* -------- ----xxxx --+----+ +++-+-+- == (pow(10.0,-3.03451) == 0.0009236133) * 1<<30   #146 */ \
        QF30_UINT(0.0008804524), /* -------- ----xxx- -x+-++-- +++---++ == (pow(10.0,-3.05529) == 0.0008804524) * 1<<30   #147 */ \
        QF30_UINT(0.0008393084), /* -------- ----xx-x xx------ -+-+---+ == (pow(10.0,-3.07608) == 0.0008393084) * 1<<30   #148 */ \
        QF30_UINT(0.0008000871), /* -------- ----xx-x ---++-++ ++--++++ == (pow(10.0,-3.09686) == 0.0008000871) * 1<<30   #149 */ \
        QF30_UINT(0.0007626986), /* -------- ----xx-- -x+++++- ++++++-+ == (pow(10.0,-3.11765) == 0.0007626986) * 1<<30   #150 */ \
        QF30_UINT(0.0007270573), /* -------- ----x-xx xx+-+--+ +------- == (pow(10.0,-3.13843) == 0.0007270573) * 1<<30   #151 */ \
        QF30_UINT(0.0006930815), /* -------- ----x-xx -x-++-+- ++++++++ == (pow(10.0,-3.15922) == 0.0006930815) * 1<<30   #152 */ \
        QF30_UINT(0.0006606934), /* -------- ----x-x- xx-+--++ --+--++- == (pow(10.0,-3.18000) == 0.0006606934) * 1<<30   #153 */ \
        QF30_UINT(0.0006298189), /* -------- ----x-x- -x-+---+ +-+--+++ == (pow(10.0,-3.20078) == 0.0006298189) * 1<<30   #154 */ \
        QF30_UINT(0.0006003871), /* -------- ----x--x xx-+-++- --++-+-+ == (pow(10.0,-3.22157) == 0.0006003871) * 1<<30   #155 */ \
        QF30_UINT(0.0005723307), /* -------- ----x--x -x+----- +----+++ == (pow(10.0,-3.24235) == 0.0005723307) * 1<<30   #156 */ \
        QF30_UINT(0.0005455854), /* -------- ----x--- xx++---- -+-++-+- == (pow(10.0,-3.26314) == 0.0005455854) * 1<<30   #157 */ \
        QF30_UINT(0.0005200899), /* -------- ----x--- x----+-+ -++-+-+- == (pow(10.0,-3.28392) == 0.0005200899) * 1<<30   #158 */ \
        QF30_UINT(0.0004957858), /* -------- ----x--- ---+++++ -++++-+- == (pow(10.0,-3.30471) == 0.0004957858) * 1<<30   #159 */ \
        QF30_UINT(0.0004726175), /* -------- -----xxx x-+++++- -+--++-+ == (pow(10.0,-3.32549) == 0.0004726175) * 1<<30   #160 */ \
        QF30_UINT(0.0004505318), /* -------- -----xxx -x+----+ +-+-+-++ == (pow(10.0,-3.34627) == 0.0004505318) * 1<<30   #161 */ \
        QF30_UINT(0.0004294783), /* -------- -----xxx ----+--+ -+-+++-+ == (pow(10.0,-3.36706) == 0.0004294783) * 1<<30   #162 */ \
        QF30_UINT(0.0004094085), /* -------- -----xx- x-++-+-+ --+-++++ == (pow(10.0,-3.38784) == 0.0004094085) * 1<<30   #163 */ \
        QF30_UINT(0.0003902766), /* -------- -----xx- -x+--+-- ++++---- == (pow(10.0,-3.40863) == 0.0003902766) * 1<<30   #164 */ \
        QF30_UINT(0.0003720388), /* -------- -----xx- ---++--- -+++--+- == (pow(10.0,-3.42941) == 0.0003720388) * 1<<30   #165 */ \
        QF30_UINT(0.0003546532), /* -------- -----x-x xx--++++ +----++- == (pow(10.0,-3.45020) == 0.0003546532) * 1<<30   #166 */ \
        QF30_UINT(0.0003380801), /* -------- -----x-x x---+-+- ------++ == (pow(10.0,-3.47098) == 0.0003380801) * 1<<30   #167 */ \
        QF30_UINT(0.0003222814), /* -------- -----x-x -x---+++ +-++++++ == (pow(10.0,-3.49176) == 0.0003222814) * 1<<30   #168 */ \
        QF30_UINT(0.0003072211), /* -------- -----x-x ----+--- +--+-+-- == (pow(10.0,-3.51255) == 0.0003072211) * 1<<30   #169 */ \
        QF30_UINT(0.0002928645), /* -------- -----x-- xx--++-- -+-+++-+ == (pow(10.0,-3.53333) == 0.0002928645) * 1<<30   #170 */ \
        QF30_UINT(0.0002791787), /* -------- -----x-- x--+--+- ++++-++- == (pow(10.0,-3.55412) == 0.0002791787) * 1<<30   #171 */ \
        QF30_UINT(0.0002661326), /* -------- -----x-- -x-+++-- --+++++- == (pow(10.0,-3.57490) == 0.0002661326) * 1<<30   #172 */ \
        QF30_UINT(0.0002536961), /* -------- -----x-- --+-+--- ---+-+-- == (pow(10.0,-3.59569) == 0.0002536961) * 1<<30   #173 */ \
        QF30_UINT(0.0002418407), /* -------- ------xx xx++-++- -+-++-+- == (pow(10.0,-3.61647) == 0.0002418407) * 1<<30   #174 */ \
        QF30_UINT(0.0002305394), /* -------- ------xx xx---++- ++++-+-- == (pow(10.0,-3.63725) == 0.0002305394) * 1<<30   #175 */ \
        QF30_UINT(0.0002197661), /* -------- ------xx x--++--+ ++---+-- == (pow(10.0,-3.65804) == 0.0002197661) * 1<<30   #176 */ \
        QF30_UINT(0.0002094964), /* -------- ------xx -x+-+++- +-++---+ == (pow(10.0,-3.67882) == 0.0002094964) * 1<<30   #177 */ \
        QF30_UINT(0.0001997065), /* -------- ------xx -x---+-+ +-+----+ == (pow(10.0,-3.69961) == 0.0001997065) * 1<<30   #178 */ \
        QF30_UINT(0.0001903741), /* -------- ------xx ---++++- -+++++-+ == (pow(10.0,-3.72039) == 0.0001903741) * 1<<30   #179 */ \
        QF30_UINT(0.0001814778), /* -------- ------x- xx+++--+ --+-++-- == (pow(10.0,-3.74118) == 0.0001814778) * 1<<30   #180 */ \
        QF30_UINT(0.0001729973), /* -------- ------x- xx-+-+-+ +--++-+- == (pow(10.0,-3.76196) == 0.0001729973) * 1<<30   #181 */ \
        QF30_UINT(0.0001649130), /* -------- ------x- x-++--++ +-++--+- == (pow(10.0,-3.78275) == 0.0001649130) * 1<<30   #182 */ \
        QF30_UINT(0.0001572065), /* -------- ------x- x--+--++ -+-+++++ == (pow(10.0,-3.80353) == 0.0001572065) * 1<<30   #183 */ \
        QF30_UINT(0.0001498602), /* -------- ------x- -x++-+-- +---++++ == (pow(10.0,-3.82431) == 0.0001498602) * 1<<30   #184 */ \
        QF30_UINT(0.0001428571), /* -------- ------x- -x-+-+++ --++---- == (pow(10.0,-3.84510) == 0.0001428571) * 1<<30   #185 */ \
        QF30_UINT(0.0001361814), /* -------- ------x- --+++-++ --++---- == (pow(10.0,-3.86588) == 0.0001361814) * 1<<30   #186 */ \
        QF30_UINT(0.0001298175), /* -------- ------x- --+----- -+++++++ == (pow(10.0,-3.88667) == 0.0001298175) * 1<<30   #187 */ \
        QF30_UINT(0.0001237511), /* -------- ------x- -----+++ ----++-+ == (pow(10.0,-3.90745) == 0.0001237511) * 1<<30   #188 */ \
        QF30_UINT(0.0001179681), /* -------- -------x xx+-+++- ++--+-++ == (pow(10.0,-3.92824) == 0.0001179681) * 1<<30   #189 */ \
        QF30_UINT(0.0001124554), /* -------- -------x xx-+-+++ +-+-++-- == (pow(10.0,-3.94902) == 0.0001124554) * 1<<30   #190 */ \
        QF30_UINT(0.0001072003), /* -------- -------x xx-----+ +-+----+ == (pow(10.0,-3.96980) == 0.0001072003) * 1<<30   #191 */ \
        QF30_UINT(0.0001021908), /* -------- -------x x-+-++-- +--+++++ == (pow(10.0,-3.99059) == 0.0001021908) * 1<<30   #192 */ \
        QF30_UINT(0.0000974154), /* -------- -------x x--++--- +--+-+++ == (pow(10.0,-4.01137) == 0.0000974154) * 1<<30   #193 */ \
        QF30_UINT(0.0000928631), /* -------- -------x x----+-+ -+++++++ == (pow(10.0,-4.03216) == 0.0000928631) * 1<<30   #194 */ \
        QF30_UINT(0.0000885236), /* -------- -------x -x++--++ -+--+-++ == (pow(10.0,-4.05294) == 0.0000885236) * 1<<30   #195 */ \
        QF30_UINT(0.0000843868), /* -------- -------x -x+----+ ++++--+- == (pow(10.0,-4.07373) == 0.0000843868) * 1<<30   #196 */ \
        QF30_UINT(0.0000804434), /* -------- -------x -x-+---+ -++--+++ == (pow(10.0,-4.09451) == 0.0000804434) * 1<<30   #197 */ \
        QF30_UINT(0.0000766842), /* -------- -------x -x-----+ +-+---++ == (pow(10.0,-4.11529) == 0.0000766842) * 1<<30   #198 */ \
        QF30_UINT(0.0000731007), /* -------- -------x --++--+- +--++-++ == (pow(10.0,-4.13608) == 0.0000731007) * 1<<30   #199 */ \
        QF30_UINT(0.0000696847), /* -------- -------x --+--+-- -+---+++ == (pow(10.0,-4.15686) == 0.0000696847) * 1<<30   #200 */ \
        QF30_UINT(0.0000664283), /* -------- -------x ---+-++- +--+++++ == (pow(10.0,-4.17765) == 0.0000664283) * 1<<30   #201 */ \
        QF30_UINT(0.0000633240), /* -------- -------x ----+--+ +--++-+- == (pow(10.0,-4.19843) == 0.0000633240) * 1<<30   #202 */ \
        QF30_UINT(0.0000603649), /* -------- -------- xx++++-+ --++---- == (pow(10.0,-4.21922) == 0.0000603649) * 1<<30   #203 */ \
        QF30_UINT(0.0000575440), /* -------- -------- xx++---+ -+-++-++ == (pow(10.0,-4.24000) == 0.0000575440) * 1<<30   #204 */ \
        QF30_UINT(0.0000548549), /* -------- -------- xx+--++- ---+-+-- == (pow(10.0,-4.26078) == 0.0000548549) * 1<<30   #205 */ \
        QF30_UINT(0.0000522915), /* -------- -------- xx-++-++ -+-+-+-- == (pow(10.0,-4.28157) == 0.0000522915) * 1<<30   #206 */ \
        QF30_UINT(0.0000498479), /* -------- -------- xx-+---+ ---+-+-- == (pow(10.0,-4.30235) == 0.0000498479) * 1<<30   #207 */ \
        QF30_UINT(0.0000475185), /* -------- -------- xx---+++ -+--++++ == (pow(10.0,-4.32314) == 0.0000475185) * 1<<30   #208 */ \
        QF30_UINT(0.0000452979), /* -------- -------- x-++++-+ +++++++- == (pow(10.0,-4.34392) == 0.0000452979) * 1<<30   #209 */ \
        QF30_UINT(0.0000431811), /* -------- -------- x-++-+-+ ---+++-+ == (pow(10.0,-4.36471) == 0.0000431811) * 1<<30   #210 */ \
        QF30_UINT(0.0000411633), /* -------- -------- x-+-++-- +-+--+++ == (pow(10.0,-4.38549) == 0.0000411633) * 1<<30   #211 */ \
        QF30_UINT(0.0000392397), /* -------- -------- x-+--+-- +--+-+-+ == (pow(10.0,-4.40627) == 0.0000392397) * 1<<30   #212 */ \
        QF30_UINT(0.0000374060), /* -------- -------- x--+++-- +++--+-- == (pow(10.0,-4.42706) == 0.0000374060) * 1<<30   #213 */ \
        QF30_UINT(0.0000356580), /* -------- -------- x--+-+-+ +---++++ == (pow(10.0,-4.44784) == 0.0000356580) * 1<<30   #214 */ \
        QF30_UINT(0.0000339917), /* -------- -------- x---+++- +--+--+- == (pow(10.0,-4.46863) == 0.0000339917) * 1<<30   #215 */ \
        QF30_UINT(0.0000324032), /* -------- -------- x----+++ +++-+--+ == (pow(10.0,-4.48941) == 0.0000324032) * 1<<30   #216 */ \
        QF30_UINT(0.0000308890), /* -------- -------- x------+ +---++++ == (pow(10.0,-4.51020) == 0.0000308890) * 1<<30   #217 */ \
        QF30_UINT(0.0000294455), /* -------- -------- -x+++-++ +------+ == (pow(10.0,-4.53098) == 0.0000294455) * 1<<30   #218 */ \
        QF30_UINT(0.0000280695), /* -------- -------- -x++-+-+ +-+++-++ == (pow(10.0,-4.55176) == 0.0000280695) * 1<<30   #219 */ \
        QF30_UINT(0.0000267578), /* -------- -------- -x++---- --+++-++ == (pow(10.0,-4.57255) == 0.0000267578) * 1<<30   #220 */ \
        QF30_UINT(0.0000255074), /* -------- -------- -x+-+-+- ++++++-- == (pow(10.0,-4.59333) == 0.0000255074) * 1<<30   #221 */ \
        QF30_UINT(0.0000243155), /* -------- -------- -x+--+-+ ++++++-+ == (pow(10.0,-4.61412) == 0.0000243155) * 1<<30   #222 */ \
        QF30_UINT(0.0000231792), /* -------- -------- -x+----+ --+++--- == (pow(10.0,-4.63490) == 0.0000231792) * 1<<30   #223 */ \
        QF30_UINT(0.0000220960), /* -------- -------- -x-+++-- +-+-++-+ == (pow(10.0,-4.65569) == 0.0000220960) * 1<<30   #224 */ \
        QF30_UINT(0.0000210634), /* -------- -------- -x-++--- -+-++--+ == (pow(10.0,-4.67647) == 0.0000210634) * 1<<30   #225 */ \
        QF30_UINT(0.0000200791), /* -------- -------- -x-+-+-- --+++--- == (pow(10.0,-4.69725) == 0.0000200791) * 1<<30   #226 */ \
        QF30_UINT(0.0000191408), /* -------- -------- -x-+---- -+--+--- == (pow(10.0,-4.71804) == 0.0000191408) * 1<<30   #227 */ \
        QF30_UINT(0.0000182464), /* -------- -------- -x--++-- +---+--- == (pow(10.0,-4.73882) == 0.0000182464) * 1<<30   #228 */ \
        QF30_UINT(0.0000173937), /* -------- -------- -x--+--- ++++-+-- == (pow(10.0,-4.75961) == 0.0000173937) * 1<<30   #229 */ \
        QF30_UINT(0.0000165809), /* -------- -------- -x---+-+ +---++-- == (pow(10.0,-4.78039) == 0.0000165809) * 1<<30   #230 */ \
        QF30_UINT(0.0000158061), /* -------- -------- -x----+- -+--++-- == (pow(10.0,-4.80118) == 0.0000158061) * 1<<30   #231 */ \
        QF30_UINT(0.0000150674), /* -------- -------- --++++++ --++--++ == (pow(10.0,-4.82196) == 0.0000150674) * 1<<30   #232 */ \
        QF30_UINT(0.0000143633), /* -------- -------- --++++-- --+++++- == (pow(10.0,-4.84275) == 0.0000143633) * 1<<30   #233 */ \
        QF30_UINT(0.0000136921), /* -------- -------- --+++--+ -++-+++- == (pow(10.0,-4.86353) == 0.0000136921) * 1<<30   #234 */ \
        QF30_UINT(0.0000130523), /* -------- -------- --++-++- +-++++++ == (pow(10.0,-4.88431) == 0.0000130523) * 1<<30   #235 */ \
        QF30_UINT(0.0000124423), /* -------- -------- --++-+-- --++---- == (pow(10.0,-4.90510) == 0.0000124423) * 1<<30   #236 */ \
        QF30_UINT(0.0000118609), /* -------- -------- --++---+ ++------ == (pow(10.0,-4.92588) == 0.0000118609) * 1<<30   #237 */ \
        QF30_UINT(0.0000113066), /* -------- -------- --+-++++ -++-++-- == (pow(10.0,-4.94667) == 0.0000113066) * 1<<30   #238 */ \
        QF30_UINT(0.0000107783), /* -------- -------- --+-++-+ --++-+-+ == (pow(10.0,-4.96745) == 0.0000107783) * 1<<30   #239 */ \
        QF30_UINT(0.0000102746), /* -------- -------- --+-+-++ ---++--- == (pow(10.0,-4.98824) == 0.0000102746) * 1<<30   #240 */ \
        QF30_UINT(0.0000097945), /* -------- -------- --+-+--+ ---+-+-+ == (pow(10.0,-5.00902) == 0.0000097945) * 1<<30   #241 */ \
        QF30_UINT(0.0000093368), /* -------- -------- --+--+++ --+-+--+ == (pow(10.0,-5.02980) == 0.0000093368) * 1<<30   #242 */ \
        QF30_UINT(0.0000089004), /* -------- -------- --+--+-+ -+-+-+-+ == (pow(10.0,-5.05059) == 0.0000089004) * 1<<30   #243 */ \
        QF30_UINT(0.0000084845), /* -------- -------- --+---++ +--+-++- == (pow(10.0,-5.07137) == 0.0000084845) * 1<<30   #244 */ \
        QF30_UINT(0.0000080880), /* -------- -------- --+----+ +++-++-- == (pow(10.0,-5.09216) == 0.0000080880) * 1<<30   #245 */ \
        QF30_UINT(0.0000077101), /* -------- -------- --+----- -+-+-+++ == (pow(10.0,-5.11294) == 0.0000077101) * 1<<30   #246 */ \
        QF30_UINT(0.0000073498), /* -------- -------- ---++++- ++-+-+-- == (pow(10.0,-5.13373) == 0.0000073498) * 1<<30   #247 */ \
        QF30_UINT(0.0000070063), /* -------- -------- ---+++-+ -++---++ == (pow(10.0,-5.15451) == 0.0000070063) * 1<<30   #248 */ \
        QF30_UINT(0.0000066789), /* -------- -------- ---+++-- ------++ == (pow(10.0,-5.17529) == 0.0000066789) * 1<<30   #249 */ \
        QF30_UINT(0.0000063668), /* -------- -------- ---++-+- +-++-+-- == (pow(10.0,-5.19608) == 0.0000063668) * 1<<30   #250 */ \
        QF30_UINT(0.0000060693), /* -------- -------- ---++--+ -+++-+-+ == (pow(10.0,-5.21686) == 0.0000060693) * 1<<30   #251 */ \
        QF30_UINT(0.0000057857), /* -------- -------- ---++--- -+---+-- == (pow(10.0,-5.23765) == 0.0000057857) * 1<<30   #252 */ \
        QF30_UINT(0.0000055153), /* -------- -------- ---+-+++ --+---+- == (pow(10.0,-5.25843) == 0.0000055153) * 1<<30   #253 */ \
        QF30_UINT(0.0000052576), /* -------- -------- ---+-++- ----++-+ == (pow(10.0,-5.27922) == 0.0000052576) * 1<<30   #254 */ \
        QF30_UINT(0.0000050119), /* -------- -------- ---+-+-+ -----+-+ == (pow(10.0,-5.30000) == 0.0000050119) * 1<<30   #255 */ \
        QF30_UINT(0.0000047777),/* -------- -------- ---+-+-- ----+-+- == (pow(10.0,-5.32078) == 0.0000047777) * 1<<30   #256 */

#define QF30_INT(x) ( static_cast<int32_t>( (x) * ( 1 << 30)) )

#define NN_AUDIO_DSP_SIN_TABLE \
        QF30_INT(0.0000000000f), /* -------- -------- -------- -------- == (sin(2*PI*0/256) == 0.0000000000) * 1<<30 */ \
        QF30_INT(0.0245412285f), /* -------+ +--+--+- ---+-+-+ -+-+++++ == (sin(2*PI*1/256) == 0.0245412285) * 1<<30 */ \
        QF30_INT(0.0490676743f), /* ------++ --+---++ +++-++-- +-+++++- == (sin(2*PI*2/256) == 0.0490676743) * 1<<30 */ \
        QF30_INT(0.0735645636f), /* -----+-- +-++-+-+ -+--+--- --+--+-+ == (sin(2*PI*3/256) == 0.0735645636) * 1<<30 */ \
        QF30_INT(0.0980171403f), /* -----++- -+---+-+ +++-+--+ +-+-++++ == (sin(2*PI*4/256) == 0.0980171403) * 1<<30 */ \
        QF30_INT(0.1224106752f), /* -----+++ ++-+-+-+ +--+--++ +--+-++- == (sin(2*PI*5/256) == 0.1224106752) * 1<<30 */ \
        QF30_INT(0.1467304745f), /* ----+--+ -++--+-- ----+--- --++-+++ == (sin(2*PI*6/256) == 0.1467304745) * 1<<30 */ \
        QF30_INT(0.1709618888f), /* ----+-+- ++++---+ ----+-+- --+---+- == (sin(2*PI*7/256) == 0.1709618888) * 1<<30 */ \
        QF30_INT(0.1950903220f), /* ----++-- -+++++-- -+-+++-- ---++++- == (sin(2*PI*8/256) == 0.1950903220) * 1<<30 */ \
        QF30_INT(0.2191012402f), /* ----+++- -----+-+ ++-----+ --++-+-+ == (sin(2*PI*9/256) == 0.2191012402) * 1<<30 */ \
        QF30_INT(0.2429801799f), /* ----++++ +---++-- ++++++-- +-+++++- == (sin(2*PI*10/256) == 0.2429801799) * 1<<30 */ \
        QF30_INT(0.2667127575f), /* ---+---+ ---+---+ ++-+--+- -++---++ == (sin(2*PI*11/256) == 0.2667127575) * 1<<30 */ \
        QF30_INT(0.2902846773f), /* ---+--+- +--+-+-- -----++- --+-++++ == (sin(2*PI*12/256) == 0.2902846773) * 1<<30 */ \
        QF30_INT(0.3136817404f), /* ---+-+-- ---+--++ -+-+++-- +--+-+-- == (sin(2*PI*13/256) == 0.3136817404) * 1<<30 */ \
        QF30_INT(0.3368898534f), /* ---+-+-+ +---++++ +--++-+- -+++-++- == (sin(2*PI*14/256) == 0.3368898534) * 1<<30 */ \
        QF30_INT(0.3598950365f), /* ---+-+++ ----+--- +----+-+ --++---+ == (sin(2*PI*15/256) == 0.3598950365) * 1<<30 */ \
        QF30_INT(0.3826834324f), /* ---++--- -+++++-+ +++---+- +-+--+++ == (sin(2*PI*16/256) == 0.3826834324) * 1<<30 */ \
        QF30_INT(0.4052413140f), /* ---++--+ +++-++++ -++++--+ -+---+-- == (sin(2*PI*17/256) == 0.4052413140) * 1<<30 */ \
        QF30_INT(0.4275550934f), /* ---++-++ -+-+++-+ ---+---- ----+-+- == (sin(2*PI*18/256) == 0.4275550934) * 1<<30 */ \
        QF30_INT(0.4496113297f), /* ---+++-- ++---++- -++-+++- +--++--+ == (sin(2*PI*19/256) == 0.4496113297) * 1<<30 */ \
        QF30_INT(0.4713967368f), /* ---++++- --+-+-++ -+-+++-+ --+++--- == (sin(2*PI*20/256) == 0.4713967368) * 1<<30 */ \
        QF30_INT(0.4928981922f), /* ---+++++ +---+-++ +-+--+-- ++-+++-- == (sin(2*PI*21/256) == 0.4928981922) * 1<<30 */ \
        QF30_INT(0.5141027442f), /* --+----- +++--+++ ----++++ --++--+- == (sin(2*PI*22/256) == 0.5141027442) * 1<<30 */ \
        QF30_INT(0.5349976199f), /* --+---+- --++++-+ -++--++- +-+-+--- == (sin(2*PI*23/256) == 0.5349976199) * 1<<30 */ \
        QF30_INT(0.5555702330f), /* --+---++ +---+++- -+++-++- -+++--++ == (sin(2*PI*24/256) == 0.5555702330) * 1<<30 */ \
        QF30_INT(0.5758081914f), /* --+--+-- ++-++-+- ----+-+- +--++-+- == (sin(2*PI*25/256) == 0.5758081914) * 1<<30 */ \
        QF30_INT(0.5956993045f), /* --+--++- ---+++++ +++-++++ +++++-+- == (sin(2*PI*26/256) == 0.5956993045) * 1<<30 */ \
        QF30_INT(0.6152315906f), /* --+--+++ -+-+++++ ++++-+-- -+-+--+- == (sin(2*PI*27/256) == 0.6152315906) * 1<<30 */ \
        QF30_INT(0.6343932842f), /* --+-+--- +--++--+ +++--++- -+--+-+- == (sin(2*PI*28/256) == 0.6343932842) * 1<<30 */ \
        QF30_INT(0.6531728430f), /* --+-+--+ ++--++-+ +--+-+-+ -++++--- == (sin(2*PI*29/256) == 0.6531728430) * 1<<30 */ \
        QF30_INT(0.6715589548f), /* --+-+-+- +++++-+- ++-+--+- -++-+--+ == (sin(2*PI*30/256) == 0.6715589548) * 1<<30 */ \
        QF30_INT(0.6895405447f), /* --+-++-- --+----+ -++-+++- +-+-+-+- == (sin(2*PI*31/256) == 0.6895405447) * 1<<30 */ \
        QF30_INT(0.7071067812f), /* --+-++-+ -+-----+ --++++-- ++--++-+ == (sin(2*PI*32/256) == 0.7071067812) * 1<<30 */ \
        QF30_INT(0.7242470830f), /* --+-+++- -+-++-+- ---+---- -+++---- == (sin(2*PI*33/256) == 0.7242470830) * 1<<30 */ \
        QF30_INT(0.7409511254f), /* --+-++++ -++-+-++ +-+++++- -+---+-+ == (sin(2*PI*34/256) == 0.7409511254) * 1<<30 */ \
        QF30_INT(0.7572088465f), /* --++---- -+++-++- ---+++-- ---++--- == (sin(2*PI*35/256) == 0.7572088465) * 1<<30 */ \
        QF30_INT(0.7730104534f), /* --++---+ -++++--+ -------- ++-+-++- == (sin(2*PI*36/256) == 0.7730104534) * 1<<30 */ \
        QF30_INT(0.7883464276f), /* --++--+- -+++-+-- -+---+-- +--+--++ == (sin(2*PI*37/256) == 0.7883464276) * 1<<30 */ \
        QF30_INT(0.8032075315f), /* --++--++ -++--+++ ++------ +--+---- == (sin(2*PI*38/256) == 0.8032075315) * 1<<30 */ \
        QF30_INT(0.8175848132f), /* --++-+-- -+-+--++ -+--++++ -+-----+ == (sin(2*PI*39/256) == 0.8175848132) * 1<<30 */ \
        QF30_INT(0.8314696123f), /* --++-+-+ --++-++- ++--++-- -+-+--+- == (sin(2*PI*40/256) == 0.8314696123) * 1<<30 */ \
        QF30_INT(0.8448535652f), /* --++-++- ---+--+- ---+-+-- +-++---- == (sin(2*PI*41/256) == 0.8448535652) * 1<<30 */ \
        QF30_INT(0.8577286100f), /* --++-++- +++--+-+ -----++- +---+-+- == (sin(2*PI*42/256) == 0.8577286100) * 1<<30 */ \
        QF30_INT(0.8700869911f), /* --++-+++ +-+-++++ +------+ -+-++--+ == (sin(2*PI*43/256) == 0.8700869911) * 1<<30 */ \
        QF30_INT(0.8819212643f), /* --+++--- -+++---+ -++--+-+ +++---++ == (sin(2*PI*44/256) == 0.8819212643) * 1<<30 */ \
        QF30_INT(0.8932243012f), /* --+++--+ --+-+-+- +--+-++- -+----+- == (sin(2*PI*45/256) == 0.8932243012) * 1<<30 */ \
        QF30_INT(0.9039892931f), /* --+++--+ ++-++-+- ++++-+-+ +++-+--- == (sin(2*PI*46/256) == 0.9039892931) * 1<<30 */ \
        QF30_INT(0.9142097557f), /* --+++-+- +-----+- -++-+--+ +-+---++ == (sin(2*PI*47/256) == 0.9142097557) * 1<<30 */ \
        QF30_INT(0.9238795325f), /* --+++-++ --+----- ++-+-+++ +--++++- == (sin(2*PI*48/256) == 0.9238795325) * 1<<30 */ \
        QF30_INT(0.9329927988f), /* --+++-++ +-++-++- --+--+++ -++-+++- == (sin(2*PI*49/256) == 0.9329927988) * 1<<30 */ \
        QF30_INT(0.9415440652f), /* --++++-- -+----+- -+----+- ----+-+- == (sin(2*PI*50/256) == 0.9415440652) * 1<<30 */ \
        QF30_INT(0.9495281806f), /* --++++-- ++---+-+ ---+---+ ++-++--+ == (sin(2*PI*51/256) == 0.9495281806) * 1<<30 */ \
        QF30_INT(0.9569403357f), /* --++++-+ --+++++- +-----+- +-+-+++- == (sin(2*PI*52/256) == 0.9569403357) * 1<<30 */ \
        QF30_INT(0.9637760658f), /* --++++-+ +-+-+++- +------+ ++--++++ == (sin(2*PI*53/256) == 0.9637760658) * 1<<30 */ \
        QF30_INT(0.9700312532f), /* --+++++- ---+-+-- ++++++-+ ++++-+++ == (sin(2*PI*54/256) == 0.9700312532) * 1<<30 */ \
        QF30_INT(0.9757021300f), /* --+++++- -+++---+ +++--+++ -+-++--+ == (sin(2*PI*55/256) == 0.9757021300) * 1<<30 */ \
        QF30_INT(0.9807852804f), /* --+++++- ++---+-+ --+-++++ +-+----- == (sin(2*PI*56/256) == 0.9807852804) * 1<<30 */ \
        QF30_INT(0.9852776424f), /* --++++++ ----+++- ++--+--+ ++++-+-+ == (sin(2*PI*57/256) == 0.9852776424) * 1<<30 */ \
        QF30_INT(0.9891765100f), /* --++++++ -+--+++- +-+-+-+- +++++++- == (sin(2*PI*58/256) == 0.9891765100) * 1<<30 */ \
        QF30_INT(0.9924795346f), /* --++++++ +----+-- ++--+--- +++---+- == (sin(2*PI*59/256) == 0.9924795346) * 1<<30 */ \
        QF30_INT(0.9951847267f), /* --++++++ +-++---+ ---++-++ -+--+--- == (sin(2*PI*60/256) == 0.9951847267) * 1<<30 */ \
        QF30_INT(0.9972904567f), /* --++++++ ++-+--++ +--++-++ -+-++-+- == (sin(2*PI*61/256) == 0.9972904567) * 1<<30 */ \
        QF30_INT(0.9987954562f), /* --++++++ +++-++-- -+----++ ++---+++ == (sin(2*PI*62/256) == 0.9987954562) * 1<<30 */ \
        QF30_INT(0.9996988187f), /* --++++++ +++++-++ ---+---- ++-----+ == (sin(2*PI*63/256) == 0.9996988187) * 1<<30 */ \
        QF30_INT(1.0000000000f), /* -+------ -------- -------- -------- == (sin(2*PI*64/256) == 1.0000000000) * 1<<30 */ \
        QF30_INT(0.9996988187f), /* --++++++ +++++-++ ---+---- ++-----+ == (sin(2*PI*65/256) == 0.9996988187) * 1<<30 */ \
        QF30_INT(0.9987954562f), /* --++++++ +++-++-- -+----++ ++---+++ == (sin(2*PI*66/256) == 0.9987954562) * 1<<30 */ \
        QF30_INT(0.9972904567f), /* --++++++ ++-+--++ +--++-++ -+-++-+- == (sin(2*PI*67/256) == 0.9972904567) * 1<<30 */ \
        QF30_INT(0.9951847267f), /* --++++++ +-++---+ ---++-++ -+--+--- == (sin(2*PI*68/256) == 0.9951847267) * 1<<30 */ \
        QF30_INT(0.9924795346f), /* --++++++ +----+-- ++--+--- +++---+- == (sin(2*PI*69/256) == 0.9924795346) * 1<<30 */ \
        QF30_INT(0.9891765100f), /* --++++++ -+--+++- +-+-+-+- +++++++- == (sin(2*PI*70/256) == 0.9891765100) * 1<<30 */ \
        QF30_INT(0.9852776424f), /* --++++++ ----+++- ++--+--+ ++++-+-+ == (sin(2*PI*71/256) == 0.9852776424) * 1<<30 */ \
        QF30_INT(0.9807852804f), /* --+++++- ++---+-+ --+-++++ +-+----- == (sin(2*PI*72/256) == 0.9807852804) * 1<<30 */ \
        QF30_INT(0.9757021300f), /* --+++++- -+++---+ +++--+++ -+-++--+ == (sin(2*PI*73/256) == 0.9757021300) * 1<<30 */ \
        QF30_INT(0.9700312532f), /* --+++++- ---+-+-- ++++++-+ ++++-+++ == (sin(2*PI*74/256) == 0.9700312532) * 1<<30 */ \
        QF30_INT(0.9637760658f), /* --++++-+ +-+-+++- +------+ ++--++++ == (sin(2*PI*75/256) == 0.9637760658) * 1<<30 */ \
        QF30_INT(0.9569403357f), /* --++++-+ --+++++- +-----+- +-+-+++- == (sin(2*PI*76/256) == 0.9569403357) * 1<<30 */ \
        QF30_INT(0.9495281806f), /* --++++-- ++---+-+ ---+---+ ++-++--+ == (sin(2*PI*77/256) == 0.9495281806) * 1<<30 */ \
        QF30_INT(0.9415440652f), /* --++++-- -+----+- -+----+- ----+-+- == (sin(2*PI*78/256) == 0.9415440652) * 1<<30 */ \
        QF30_INT(0.9329927988f), /* --+++-++ +-++-++- --+--+++ -++-+++- == (sin(2*PI*79/256) == 0.9329927988) * 1<<30 */ \
        QF30_INT(0.9238795325f), /* --+++-++ --+----- ++-+-+++ +--++++- == (sin(2*PI*80/256) == 0.9238795325) * 1<<30 */ \
        QF30_INT(0.9142097557f), /* --+++-+- +-----+- -++-+--+ +-+---++ == (sin(2*PI*81/256) == 0.9142097557) * 1<<30 */ \
        QF30_INT(0.9039892931f), /* --+++--+ ++-++-+- ++++-+-+ +++-+--- == (sin(2*PI*82/256) == 0.9039892931) * 1<<30 */ \
        QF30_INT(0.8932243012f), /* --+++--+ --+-+-+- +--+-++- -+----+- == (sin(2*PI*83/256) == 0.8932243012) * 1<<30 */ \
        QF30_INT(0.8819212643f), /* --+++--- -+++---+ -++--+-+ +++---++ == (sin(2*PI*84/256) == 0.8819212643) * 1<<30 */ \
        QF30_INT(0.8700869911f), /* --++-+++ +-+-++++ +------+ -+-++--+ == (sin(2*PI*85/256) == 0.8700869911) * 1<<30 */ \
        QF30_INT(0.8577286100f), /* --++-++- +++--+-+ -----++- +---+-+- == (sin(2*PI*86/256) == 0.8577286100) * 1<<30 */ \
        QF30_INT(0.8448535652f), /* --++-++- ---+--+- ---+-+-- +-++---- == (sin(2*PI*87/256) == 0.8448535652) * 1<<30 */ \
        QF30_INT(0.8314696123f), /* --++-+-+ --++-++- ++--++-- -+-+--+- == (sin(2*PI*88/256) == 0.8314696123) * 1<<30 */ \
        QF30_INT(0.8175848132f), /* --++-+-- -+-+--++ -+--++++ -+-----+ == (sin(2*PI*89/256) == 0.8175848132) * 1<<30 */ \
        QF30_INT(0.8032075315f), /* --++--++ -++--+++ ++------ +--+---- == (sin(2*PI*90/256) == 0.8032075315) * 1<<30 */ \
        QF30_INT(0.7883464276f), /* --++--+- -+++-+-- -+---+-- +--+--++ == (sin(2*PI*91/256) == 0.7883464276) * 1<<30 */ \
        QF30_INT(0.7730104534f), /* --++---+ -++++--+ -------- ++-+-++- == (sin(2*PI*92/256) == 0.7730104534) * 1<<30 */ \
        QF30_INT(0.7572088465f), /* --++---- -+++-++- ---+++-- ---++--- == (sin(2*PI*93/256) == 0.7572088465) * 1<<30 */ \
        QF30_INT(0.7409511254f), /* --+-++++ -++-+-++ +-+++++- -+---+-+ == (sin(2*PI*94/256) == 0.7409511254) * 1<<30 */ \
        QF30_INT(0.7242470830f), /* --+-+++- -+-++-+- ---+---- -+++---- == (sin(2*PI*95/256) == 0.7242470830) * 1<<30 */ \
        QF30_INT(0.7071067812f), /* --+-++-+ -+-----+ --++++-- ++--++-+ == (sin(2*PI*96/256) == 0.7071067812) * 1<<30 */ \
        QF30_INT(0.6895405447f), /* --+-++-- --+----+ -++-+++- +-+-+-+- == (sin(2*PI*97/256) == 0.6895405447) * 1<<30 */ \
        QF30_INT(0.6715589548f), /* --+-+-+- +++++-+- ++-+--+- -++-+--+ == (sin(2*PI*98/256) == 0.6715589548) * 1<<30 */ \
        QF30_INT(0.6531728430f), /* --+-+--+ ++--++-+ +--+-+-+ -++++--- == (sin(2*PI*99/256) == 0.6531728430) * 1<<30 */ \
        QF30_INT(0.6343932842f), /* --+-+--- +--++--+ +++--++- -+--+-+- == (sin(2*PI*100/256) == 0.6343932842) * 1<<30 */ \
        QF30_INT(0.6152315906f), /* --+--+++ -+-+++++ ++++-+-- -+-+--+- == (sin(2*PI*101/256) == 0.6152315906) * 1<<30 */ \
        QF30_INT(0.5956993045f), /* --+--++- ---+++++ +++-++++ +++++-+- == (sin(2*PI*102/256) == 0.5956993045) * 1<<30 */ \
        QF30_INT(0.5758081914f), /* --+--+-- ++-++-+- ----+-+- +--++-+- == (sin(2*PI*103/256) == 0.5758081914) * 1<<30 */ \
        QF30_INT(0.5555702330f), /* --+---++ +---+++- -+++-++- -+++--++ == (sin(2*PI*104/256) == 0.5555702330) * 1<<30 */ \
        QF30_INT(0.5349976199f), /* --+---+- --++++-+ -++--++- +-+-+--- == (sin(2*PI*105/256) == 0.5349976199) * 1<<30 */ \
        QF30_INT(0.5141027442f), /* --+----- +++--+++ ----++++ --++--+- == (sin(2*PI*106/256) == 0.5141027442) * 1<<30 */ \
        QF30_INT(0.4928981922f), /* ---+++++ +---+-++ +-+--+-- ++-+++-- == (sin(2*PI*107/256) == 0.4928981922) * 1<<30 */ \
        QF30_INT(0.4713967368f), /* ---++++- --+-+-++ -+-+++-+ --+++--- == (sin(2*PI*108/256) == 0.4713967368) * 1<<30 */ \
        QF30_INT(0.4496113297f), /* ---+++-- ++---++- -++-+++- +--++--+ == (sin(2*PI*109/256) == 0.4496113297) * 1<<30 */ \
        QF30_INT(0.4275550934f), /* ---++-++ -+-+++-+ ---+---- ----+-+- == (sin(2*PI*110/256) == 0.4275550934) * 1<<30 */ \
        QF30_INT(0.4052413140f), /* ---++--+ +++-++++ -++++--+ -+---+-- == (sin(2*PI*111/256) == 0.4052413140) * 1<<30 */ \
        QF30_INT(0.3826834324f), /* ---++--- -+++++-+ +++---+- +-+--+++ == (sin(2*PI*112/256) == 0.3826834324) * 1<<30 */ \
        QF30_INT(0.3598950365f), /* ---+-+++ ----+--- +----+-+ --++---+ == (sin(2*PI*113/256) == 0.3598950365) * 1<<30 */ \
        QF30_INT(0.3368898534f), /* ---+-+-+ +---++++ +--++-+- -+++-++- == (sin(2*PI*114/256) == 0.3368898534) * 1<<30 */ \
        QF30_INT(0.3136817404f), /* ---+-+-- ---+--++ -+-+++-- +--+-+-- == (sin(2*PI*115/256) == 0.3136817404) * 1<<30 */ \
        QF30_INT(0.2902846773f), /* ---+--+- +--+-+-- -----++- --+-++++ == (sin(2*PI*116/256) == 0.2902846773) * 1<<30 */ \
        QF30_INT(0.2667127575f), /* ---+---+ ---+---+ ++-+--+- -++---++ == (sin(2*PI*117/256) == 0.2667127575) * 1<<30 */ \
        QF30_INT(0.2429801799f), /* ----++++ +---++-- ++++++-- +-+++++- == (sin(2*PI*118/256) == 0.2429801799) * 1<<30 */ \
        QF30_INT(0.2191012402f), /* ----+++- -----+-+ ++-----+ --++-+-+ == (sin(2*PI*119/256) == 0.2191012402) * 1<<30 */ \
        QF30_INT(0.1950903220f), /* ----++-- -+++++-- -+-+++-- ---++++- == (sin(2*PI*120/256) == 0.1950903220) * 1<<30 */ \
        QF30_INT(0.1709618888f), /* ----+-+- ++++---+ ----+-+- --+---+- == (sin(2*PI*121/256) == 0.1709618888) * 1<<30 */ \
        QF30_INT(0.1467304745f), /* ----+--+ -++--+-- ----+--- --++-+++ == (sin(2*PI*122/256) == 0.1467304745) * 1<<30 */ \
        QF30_INT(0.1224106752f), /* -----+++ ++-+-+-+ +--+--++ +--+-++- == (sin(2*PI*123/256) == 0.1224106752) * 1<<30 */ \
        QF30_INT(0.0980171403f), /* -----++- -+---+-+ +++-+--+ +-+-++++ == (sin(2*PI*124/256) == 0.0980171403) * 1<<30 */ \
        QF30_INT(0.0735645636f), /* -----+-- +-++-+-+ -+--+--- --+--+-+ == (sin(2*PI*125/256) == 0.0735645636) * 1<<30 */ \
        QF30_INT(0.0490676743f), /* ------++ --+---++ +++-++-- +-+++++- == (sin(2*PI*126/256) == 0.0490676743) * 1<<30 */ \
        QF30_INT(0.0245412285f), /* -------+ +--+--+- ---+-+-+ -+-+++++ == (sin(2*PI*127/256) == 0.0245412285) * 1<<30 */ \
        QF30_INT(0.0000000000f), /* -------- -------- -------- -------- == (sin(2*PI*128/256) == 0.0000000000) * 1<<30 */ \
        QF30_INT(-0.0245412285f), /* +++++++- -++-++-+ +++-+-+- +-+---+- == (sin(2*PI*129/256) == -0.0245412285) * 1<<30 */ \
        QF30_INT(-0.0490676743f), /* ++++++-- ++-+++-- ---+--++ -+----++ == (sin(2*PI*130/256) == -0.0490676743) * 1<<30 */ \
        QF30_INT(-0.0735645636f), /* +++++-++ -+--+-+- +-++-+++ ++-+++-- == (sin(2*PI*131/256) == -0.0735645636) * 1<<30 */ \
        QF30_INT(-0.0980171403f), /* +++++--+ +-+++-+- ---+-++- -+-+--+- == (sin(2*PI*132/256) == -0.0980171403) * 1<<30 */ \
        QF30_INT(-0.1224106752f), /* +++++--- --+-+-+- -++-++-- -++-+-++ == (sin(2*PI*133/256) == -0.1224106752) * 1<<30 */ \
        QF30_INT(-0.1467304745f), /* ++++-++- +--++-++ ++++-+++ ++--+-+- == (sin(2*PI*134/256) == -0.1467304745) * 1<<30 */ \
        QF30_INT(-0.1709618888f), /* ++++-+-+ ----+++- ++++-+-+ ++-+++++ == (sin(2*PI*135/256) == -0.1709618888) * 1<<30 */ \
        QF30_INT(-0.1950903220f), /* ++++--++ +-----++ +-+---++ +++---++ == (sin(2*PI*136/256) == -0.1950903220) * 1<<30 */ \
        QF30_INT(-0.2191012402f), /* ++++---+ +++++-+- --+++++- ++--++-- == (sin(2*PI*137/256) == -0.2191012402) * 1<<30 */ \
        QF30_INT(-0.2429801799f), /* ++++---- -+++--++ ------++ -+----++ == (sin(2*PI*138/256) == -0.2429801799) * 1<<30 */ \
        QF30_INT(-0.2667127575f), /* +++-+++- +++-+++- --+-++-+ +--++++- == (sin(2*PI*139/256) == -0.2667127575) * 1<<30 */ \
        QF30_INT(-0.2902846773f), /* +++-++-+ -++-+-++ +++++--+ ++-+--+- == (sin(2*PI*140/256) == -0.2902846773) * 1<<30 */ \
        QF30_INT(-0.3136817404f), /* +++-+-++ +++-++-- +-+---++ -++-++-+ == (sin(2*PI*141/256) == -0.3136817404) * 1<<30 */ \
        QF30_INT(-0.3368898534f), /* +++-+-+- -+++---- -++--+-+ +---+-++ == (sin(2*PI*142/256) == -0.3368898534) * 1<<30 */ \
        QF30_INT(-0.3598950365f), /* +++-+--- ++++-+++ -++++-+- ++-+---- == (sin(2*PI*143/256) == -0.3598950365) * 1<<30 */ \
        QF30_INT(-0.3826834324f), /* +++--+++ +-----+- ---+++-+ -+-++-+- == (sin(2*PI*144/256) == -0.3826834324) * 1<<30 */ \
        QF30_INT(-0.4052413140f), /* +++--++- ---+---- +----++- +-++++-+ == (sin(2*PI*145/256) == -0.4052413140) * 1<<30 */ \
        QF30_INT(-0.4275550934f), /* +++--+-- +-+---+- +++-++++ ++++-+++ == (sin(2*PI*146/256) == -0.4275550934) * 1<<30 */ \
        QF30_INT(-0.4496113297f), /* +++---++ --+++--+ +--+---+ -++-+--- == (sin(2*PI*147/256) == -0.4496113297) * 1<<30 */ \
        QF30_INT(-0.4713967368f), /* +++----+ ++-+-+-- +-+---+- ++--+--+ == (sin(2*PI*148/256) == -0.4713967368) * 1<<30 */ \
        QF30_INT(-0.4928981922f), /* +++----- -+++-+-- -+-++-++ --+--+-+ == (sin(2*PI*149/256) == -0.4928981922) * 1<<30 */ \
        QF30_INT(-0.5141027442f), /* ++-+++++ ---++--- ++++---- ++--++++ == (sin(2*PI*150/256) == -0.5141027442) * 1<<30 */ \
        QF30_INT(-0.5349976199f), /* ++-+++-+ ++----+- +--++--+ -+-++--+ == (sin(2*PI*151/256) == -0.5349976199) * 1<<30 */ \
        QF30_INT(-0.5555702330f), /* ++-+++-- -+++---+ +---+--+ +---+++- == (sin(2*PI*152/256) == -0.5555702330) * 1<<30 */ \
        QF30_INT(-0.5758081914f), /* ++-++-++ --+--+-+ ++++-+-+ -++--+++ == (sin(2*PI*153/256) == -0.5758081914) * 1<<30 */ \
        QF30_INT(-0.5956993045f), /* ++-++--+ +++----- ---+---- -----+++ == (sin(2*PI*154/256) == -0.5956993045) * 1<<30 */ \
        QF30_INT(-0.6152315906f), /* ++-++--- +-+----- ----+-++ +-+-++++ == (sin(2*PI*155/256) == -0.6152315906) * 1<<30 */ \
        QF30_INT(-0.6343932842f), /* ++-+-+++ -++--++- ---++--+ +-++-+++ == (sin(2*PI*156/256) == -0.6343932842) * 1<<30 */ \
        QF30_INT(-0.6531728430f), /* ++-+-++- --++--+- -++-+-+- +---+--+ == (sin(2*PI*157/256) == -0.6531728430) * 1<<30 */ \
        QF30_INT(-0.6715589548f), /* ++-+-+-+ -----+-+ --+-++-+ +--++--- == (sin(2*PI*158/256) == -0.6715589548) * 1<<30 */ \
        QF30_INT(-0.6895405447f), /* ++-+--++ ++-++++- +--+---+ -+-+-+++ == (sin(2*PI*159/256) == -0.6895405447) * 1<<30 */ \
        QF30_INT(-0.7071067812f), /* ++-+--+- +-+++++- ++----++ --++-+-- == (sin(2*PI*160/256) == -0.7071067812) * 1<<30 */ \
        QF30_INT(-0.7242470830f), /* ++-+---+ +-+--+-+ +++-++++ +--+---+ == (sin(2*PI*161/256) == -0.7242470830) * 1<<30 */ \
        QF30_INT(-0.7409511254f), /* ++-+---- +--+-+-- -+-----+ +-++++-- == (sin(2*PI*162/256) == -0.7409511254) * 1<<30 */ \
        QF30_INT(-0.7572088465f), /* ++--++++ +---+--+ +++---++ +++-+--+ == (sin(2*PI*163/256) == -0.7572088465) * 1<<30 */ \
        QF30_INT(-0.7730104534f), /* ++--+++- +----++- ++++++++ --+-+-++ == (sin(2*PI*164/256) == -0.7730104534) * 1<<30 */ \
        QF30_INT(-0.7883464276f), /* ++--++-+ +---+-++ +-+++-++ -++-+++- == (sin(2*PI*165/256) == -0.7883464276) * 1<<30 */ \
        QF30_INT(-0.8032075315f), /* ++--++-- +--++--- --++++++ -+++---+ == (sin(2*PI*166/256) == -0.8032075315) * 1<<30 */ \
        QF30_INT(-0.8175848132f), /* ++--+-++ +-+-++-- +-++---- ++------ == (sin(2*PI*167/256) == -0.8175848132) * 1<<30 */ \
        QF30_INT(-0.8314696123f), /* ++--+-+- ++--+--+ --++--++ +-+-++++ == (sin(2*PI*168/256) == -0.8314696123) * 1<<30 */ \
        QF30_INT(-0.8448535652f), /* ++--+--+ +++-++-+ +++-+-++ -+-+---+ == (sin(2*PI*169/256) == -0.8448535652) * 1<<30 */ \
        QF30_INT(-0.8577286100f), /* ++--+--+ ---++-+- +++++--+ -+++-+++ == (sin(2*PI*170/256) == -0.8577286100) * 1<<30 */ \
        QF30_INT(-0.8700869911f), /* ++--+--- -+-+---- -++++++- +-+-+--- == (sin(2*PI*171/256) == -0.8700869911) * 1<<30 */ \
        QF30_INT(-0.8819212643f), /* ++---+++ +---+++- +--++-+- ---++++- == (sin(2*PI*172/256) == -0.8819212643) * 1<<30 */ \
        QF30_INT(-0.8932243012f), /* ++---++- ++-+-+-+ -++-+--+ +-++++++ == (sin(2*PI*173/256) == -0.8932243012) * 1<<30 */ \
        QF30_INT(-0.9039892931f), /* ++---++- --+--+-+ ----+-+- ---++--+ == (sin(2*PI*174/256) == -0.9039892931) * 1<<30 */ \
        QF30_INT(-0.9142097557f), /* ++---+-+ -+++++-+ +--+-++- -+-++++- == (sin(2*PI*175/256) == -0.9142097557) * 1<<30 */ \
        QF30_INT(-0.9238795325f), /* ++---+-- ++-+++++ --+-+--- -++---++ == (sin(2*PI*176/256) == -0.9238795325) * 1<<30 */ \
        QF30_INT(-0.9329927988f), /* ++---+-- -+--+--+ ++-++--- +--+--++ == (sin(2*PI*177/256) == -0.9329927988) * 1<<30 */ \
        QF30_INT(-0.9415440652f), /* ++----++ +-++++-+ +-++++-+ ++++-+++ == (sin(2*PI*178/256) == -0.9415440652) * 1<<30 */ \
        QF30_INT(-0.9495281806f), /* ++----++ --+++-+- +++-+++- --+-+--- == (sin(2*PI*179/256) == -0.9495281806) * 1<<30 */ \
        QF30_INT(-0.9569403357f), /* ++----+- ++-----+ -+++++-+ -+-+--++ == (sin(2*PI*180/256) == -0.9569403357) * 1<<30 */ \
        QF30_INT(-0.9637760658f), /* ++----+- -+-+---+ -++++++- --++--+- == (sin(2*PI*181/256) == -0.9637760658) * 1<<30 */ \
        QF30_INT(-0.9700312532f), /* ++-----+ +++-+-++ ------+- ----+-+- == (sin(2*PI*182/256) == -0.9700312532) * 1<<30 */ \
        QF30_INT(-0.9757021300f), /* ++-----+ +---+++- ---++--- +-+-+--- == (sin(2*PI*183/256) == -0.9757021300) * 1<<30 */ \
        QF30_INT(-0.9807852804f), /* ++-----+ --+++-+- ++-+---- -++----+ == (sin(2*PI*184/256) == -0.9807852804) * 1<<30 */ \
        QF30_INT(-0.9852776424f), /* ++------ ++++---+ --++-++- ----++-- == (sin(2*PI*185/256) == -0.9852776424) * 1<<30 */ \
        QF30_INT(-0.9891765100f), /* ++------ +-++---+ -+-+-+-+ ------++ == (sin(2*PI*186/256) == -0.9891765100) * 1<<30 */ \
        QF30_INT(-0.9924795346f), /* ++------ -++++-++ --++-+++ ---+++++ == (sin(2*PI*187/256) == -0.9924795346) * 1<<30 */ \
        QF30_INT(-0.9951847267f), /* ++------ -+--+++- +++--+-- +-+++--+ == (sin(2*PI*188/256) == -0.9951847267) * 1<<30 */ \
        QF30_INT(-0.9972904567f), /* ++------ --+-++-- -++--+-- +-+--+++ == (sin(2*PI*189/256) == -0.9972904567) * 1<<30 */ \
        QF30_INT(-0.9987954562f), /* ++------ ---+--++ +-++++-- --+++-+- == (sin(2*PI*190/256) == -0.9987954562) * 1<<30 */ \
        QF30_INT(-0.9996988187f), /* ++------ -----+-- +++-++++ -+------ == (sin(2*PI*191/256) == -0.9996988187) * 1<<30 */ \
        QF30_INT(-1.0000000000f), /* ++------ -------- -------- -------+ == (sin(2*PI*192/256) == -1.0000000000) * 1<<30 */ \
        QF30_INT(-0.9996988187f), /* ++------ -----+-- +++-++++ -+------ == (sin(2*PI*193/256) == -0.9996988187) * 1<<30 */ \
        QF30_INT(-0.9987954562f), /* ++------ ---+--++ +-++++-- --+++-+- == (sin(2*PI*194/256) == -0.9987954562) * 1<<30 */ \
        QF30_INT(-0.9972904567f), /* ++------ --+-++-- -++--+-- +-+--+++ == (sin(2*PI*195/256) == -0.9972904567) * 1<<30 */ \
        QF30_INT(-0.9951847267f), /* ++------ -+--+++- +++--+-- +-+++--+ == (sin(2*PI*196/256) == -0.9951847267) * 1<<30 */ \
        QF30_INT(-0.9924795346f), /* ++------ -++++-++ --++-+++ ---+++++ == (sin(2*PI*197/256) == -0.9924795346) * 1<<30 */ \
        QF30_INT(-0.9891765100f), /* ++------ +-++---+ -+-+-+-+ ------++ == (sin(2*PI*198/256) == -0.9891765100) * 1<<30 */ \
        QF30_INT(-0.9852776424f), /* ++------ ++++---+ --++-++- ----++-- == (sin(2*PI*199/256) == -0.9852776424) * 1<<30 */ \
        QF30_INT(-0.9807852804f), /* ++-----+ --+++-+- ++-+---- -++----+ == (sin(2*PI*200/256) == -0.9807852804) * 1<<30 */ \
        QF30_INT(-0.9757021300f), /* ++-----+ +---+++- ---++--- +-+-+--- == (sin(2*PI*201/256) == -0.9757021300) * 1<<30 */ \
        QF30_INT(-0.9700312532f), /* ++-----+ +++-+-++ ------+- ----+-+- == (sin(2*PI*202/256) == -0.9700312532) * 1<<30 */ \
        QF30_INT(-0.9637760658f), /* ++----+- -+-+---+ -++++++- --++--+- == (sin(2*PI*203/256) == -0.9637760658) * 1<<30 */ \
        QF30_INT(-0.9569403357f), /* ++----+- ++-----+ -+++++-+ -+-+--++ == (sin(2*PI*204/256) == -0.9569403357) * 1<<30 */ \
        QF30_INT(-0.9495281806f), /* ++----++ --+++-+- +++-+++- --+-+--- == (sin(2*PI*205/256) == -0.9495281806) * 1<<30 */ \
        QF30_INT(-0.9415440652f), /* ++----++ +-++++-+ +-++++-+ ++++-+++ == (sin(2*PI*206/256) == -0.9415440652) * 1<<30 */ \
        QF30_INT(-0.9329927988f), /* ++---+-- -+--+--+ ++-++--- +--+--++ == (sin(2*PI*207/256) == -0.9329927988) * 1<<30 */ \
        QF30_INT(-0.9238795325f), /* ++---+-- ++-+++++ --+-+--- -++---++ == (sin(2*PI*208/256) == -0.9238795325) * 1<<30 */ \
        QF30_INT(-0.9142097557f), /* ++---+-+ -+++++-+ +--+-++- -+-++++- == (sin(2*PI*209/256) == -0.9142097557) * 1<<30 */ \
        QF30_INT(-0.9039892931f), /* ++---++- --+--+-+ ----+-+- ---++--+ == (sin(2*PI*210/256) == -0.9039892931) * 1<<30 */ \
        QF30_INT(-0.8932243012f), /* ++---++- ++-+-+-+ -++-+--+ +-++++++ == (sin(2*PI*211/256) == -0.8932243012) * 1<<30 */ \
        QF30_INT(-0.8819212643f), /* ++---+++ +---+++- +--++-+- ---++++- == (sin(2*PI*212/256) == -0.8819212643) * 1<<30 */ \
        QF30_INT(-0.8700869911f), /* ++--+--- -+-+---- -++++++- +-+-+--- == (sin(2*PI*213/256) == -0.8700869911) * 1<<30 */ \
        QF30_INT(-0.8577286100f), /* ++--+--+ ---++-+- +++++--+ -+++-+++ == (sin(2*PI*214/256) == -0.8577286100) * 1<<30 */ \
        QF30_INT(-0.8448535652f), /* ++--+--+ +++-++-+ +++-+-++ -+-+---+ == (sin(2*PI*215/256) == -0.8448535652) * 1<<30 */ \
        QF30_INT(-0.8314696123f), /* ++--+-+- ++--+--+ --++--++ +-+-++++ == (sin(2*PI*216/256) == -0.8314696123) * 1<<30 */ \
        QF30_INT(-0.8175848132f), /* ++--+-++ +-+-++-- +-++---- ++------ == (sin(2*PI*217/256) == -0.8175848132) * 1<<30 */ \
        QF30_INT(-0.8032075315f), /* ++--++-- +--++--- --++++++ -+++---+ == (sin(2*PI*218/256) == -0.8032075315) * 1<<30 */ \
        QF30_INT(-0.7883464276f), /* ++--++-+ +---+-++ +-+++-++ -++-+++- == (sin(2*PI*219/256) == -0.7883464276) * 1<<30 */ \
        QF30_INT(-0.7730104534f), /* ++--+++- +----++- ++++++++ --+-+-++ == (sin(2*PI*220/256) == -0.7730104534) * 1<<30 */ \
        QF30_INT(-0.7572088465f), /* ++--++++ +---+--+ +++---++ +++-+--+ == (sin(2*PI*221/256) == -0.7572088465) * 1<<30 */ \
        QF30_INT(-0.7409511254f), /* ++-+---- +--+-+-- -+-----+ +-++++-- == (sin(2*PI*222/256) == -0.7409511254) * 1<<30 */ \
        QF30_INT(-0.7242470830f), /* ++-+---+ +-+--+-+ +++-++++ +--+---+ == (sin(2*PI*223/256) == -0.7242470830) * 1<<30 */ \
        QF30_INT(-0.7071067812f), /* ++-+--+- +-+++++- ++----++ --++-+-- == (sin(2*PI*224/256) == -0.7071067812) * 1<<30 */ \
        QF30_INT(-0.6895405447f), /* ++-+--++ ++-++++- +--+---+ -+-+-+++ == (sin(2*PI*225/256) == -0.6895405447) * 1<<30 */ \
        QF30_INT(-0.6715589548f), /* ++-+-+-+ -----+-+ --+-++-+ +--++--- == (sin(2*PI*226/256) == -0.6715589548) * 1<<30 */ \
        QF30_INT(-0.6531728430f), /* ++-+-++- --++--+- -++-+-+- +---+--+ == (sin(2*PI*227/256) == -0.6531728430) * 1<<30 */ \
        QF30_INT(-0.6343932842f), /* ++-+-+++ -++--++- ---++--+ +-++-+++ == (sin(2*PI*228/256) == -0.6343932842) * 1<<30 */ \
        QF30_INT(-0.6152315906f), /* ++-++--- +-+----- ----+-++ +-+-++++ == (sin(2*PI*229/256) == -0.6152315906) * 1<<30 */ \
        QF30_INT(-0.5956993045f), /* ++-++--+ +++----- ---+---- -----+++ == (sin(2*PI*230/256) == -0.5956993045) * 1<<30 */ \
        QF30_INT(-0.5758081914f), /* ++-++-++ --+--+-+ ++++-+-+ -++--+++ == (sin(2*PI*231/256) == -0.5758081914) * 1<<30 */ \
        QF30_INT(-0.5555702330f), /* ++-+++-- -+++---+ +---+--+ +---+++- == (sin(2*PI*232/256) == -0.5555702330) * 1<<30 */ \
        QF30_INT(-0.5349976199f), /* ++-+++-+ ++----+- +--++--+ -+-++--+ == (sin(2*PI*233/256) == -0.5349976199) * 1<<30 */ \
        QF30_INT(-0.5141027442f), /* ++-+++++ ---++--- ++++---- ++--++++ == (sin(2*PI*234/256) == -0.5141027442) * 1<<30 */ \
        QF30_INT(-0.4928981922f), /* +++----- -+++-+-- -+-++-++ --+--+-+ == (sin(2*PI*235/256) == -0.4928981922) * 1<<30 */ \
        QF30_INT(-0.4713967368f), /* +++----+ ++-+-+-- +-+---+- ++--+--+ == (sin(2*PI*236/256) == -0.4713967368) * 1<<30 */ \
        QF30_INT(-0.4496113297f), /* +++---++ --+++--+ +--+---+ -++-+--- == (sin(2*PI*237/256) == -0.4496113297) * 1<<30 */ \
        QF30_INT(-0.4275550934f), /* +++--+-- +-+---+- +++-++++ ++++-+++ == (sin(2*PI*238/256) == -0.4275550934) * 1<<30 */ \
        QF30_INT(-0.4052413140f), /* +++--++- ---+---- +----++- +-++++-+ == (sin(2*PI*239/256) == -0.4052413140) * 1<<30 */ \
        QF30_INT(-0.3826834324f), /* +++--+++ +-----+- ---+++-+ -+-++-+- == (sin(2*PI*240/256) == -0.3826834324) * 1<<30 */ \
        QF30_INT(-0.3598950365f), /* +++-+--- ++++-+++ -++++-+- ++-+---- == (sin(2*PI*241/256) == -0.3598950365) * 1<<30 */ \
        QF30_INT(-0.3368898534f), /* +++-+-+- -+++---- -++--+-+ +---+-++ == (sin(2*PI*242/256) == -0.3368898534) * 1<<30 */ \
        QF30_INT(-0.3136817404f), /* +++-+-++ +++-++-- +-+---++ -++-++-+ == (sin(2*PI*243/256) == -0.3136817404) * 1<<30 */ \
        QF30_INT(-0.2902846773f), /* +++-++-+ -++-+-++ +++++--+ ++-+--+- == (sin(2*PI*244/256) == -0.2902846773) * 1<<30 */ \
        QF30_INT(-0.2667127575f), /* +++-+++- +++-+++- --+-++-+ +--++++- == (sin(2*PI*245/256) == -0.2667127575) * 1<<30 */ \
        QF30_INT(-0.2429801799f), /* ++++---- -+++--++ ------++ -+----++ == (sin(2*PI*246/256) == -0.2429801799) * 1<<30 */ \
        QF30_INT(-0.2191012402f), /* ++++---+ +++++-+- --+++++- ++--++-- == (sin(2*PI*247/256) == -0.2191012402) * 1<<30 */ \
        QF30_INT(-0.1950903220f), /* ++++--++ +-----++ +-+---++ +++---++ == (sin(2*PI*248/256) == -0.1950903220) * 1<<30 */ \
        QF30_INT(-0.1709618888f), /* ++++-+-+ ----+++- ++++-+-+ ++-+++++ == (sin(2*PI*249/256) == -0.1709618888) * 1<<30 */ \
        QF30_INT(-0.1467304745f), /* ++++-++- +--++-++ ++++-+++ ++--+-+- == (sin(2*PI*250/256) == -0.1467304745) * 1<<30 */ \
        QF30_INT(-0.1224106752f), /* +++++--- --+-+-+- -++-++-- -++-+-++ == (sin(2*PI*251/256) == -0.1224106752) * 1<<30 */ \
        QF30_INT(-0.0980171403f), /* +++++--+ +-+++-+- ---+-++- -+-+--+- == (sin(2*PI*252/256) == -0.0980171403) * 1<<30 */ \
        QF30_INT(-0.0735645636f), /* +++++-++ -+--+-+- +-++-+++ ++-+++-- == (sin(2*PI*253/256) == -0.0735645636) * 1<<30 */ \
        QF30_INT(-0.0490676743f), /* ++++++-- ++-+++-- ---+--++ -+----++ == (sin(2*PI*254/256) == -0.0490676743) * 1<<30 */ \
        QF30_INT(-0.0245412285f), /* +++++++- -++-++-+ +++-+-+- +-+---+- == (sin(2*PI*255/256) == -0.0245412285) * 1<<30 */ \
        QF30_INT( 0.0000000000f),/* -------- -------- -------- -------- == (sin(2*PI*256/256) ==  0.0000000000) * 1<<30 */

} // namespace audio
} // namespace nn

