﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <limits>

#include <nn/nn_Common.h>

#if defined(__ARM_ACLE)
#include <arm_acle.h>
#endif  // defined(__ARM_ACLE)

namespace nn {
namespace audio {

NN_FORCEINLINE
int32_t* GetMixBuffer(int32_t* buffer, int index, int sampleCount) NN_NOEXCEPT
{
    return buffer + sampleCount * index;
}

NN_FORCEINLINE
const int32_t* GetMixBuffer(const int32_t* buffer, int index, int sampleCount) NN_NOEXCEPT
{
    return buffer + sampleCount * index;
}

template <typename T> T Max(T a, T b) NN_NOEXCEPT
{
    return a > b ? a : b;
}

template <typename T> T Min(T a, T b) NN_NOEXCEPT
{
    return a < b ? a : b;
}

template <int N, typename T> T Clamp(T value) NN_NOEXCEPT
{
#if defined(__ARM_ACLE) && (__ARM_32BIT_STATE != 0)
    return __ssat(value, N);
#else
    const T _max = (1 << (N - 1)) - 1;
    const T _min = - (1 << (N - 1));
    return Max(Min(_max, value), _min);
#endif
}

template <typename T, typename U>
T Clamp(U x) NN_NOEXCEPT
{
    const U max = static_cast<U>(std::numeric_limits<T>::max());
    const U min = static_cast<U>(std::numeric_limits<T>::min());
    x = x < max ? x : max;
    x = x > min ? x : min;
    return static_cast<T>(x);
}

}  // namespace audio
}  // namespace nn
