﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/dd/dd_DeviceAddressSpace.h>
#include <nn/applet/applet_Types.h>
#include "../audio_AddrTypes.h"
#include "../server/audio_AppletVolumeManager.h"

namespace nn { namespace audio { namespace dsp {

Result Start() NN_NOEXCEPT;
void Stop() NN_NOEXCEPT;
DspAddr MapUserPointer(nn::dd::ProcessHandle processHandle, CpuAddr buffer, size_t size) NN_NOEXCEPT;
DspAddr MapUserPointer(CpuAddr buffer, size_t size) NN_NOEXCEPT;
void UnmapUserPointer(nn::dd::ProcessHandle processHandle, CpuAddr buffer, size_t size) NN_NOEXCEPT;
void UnmapUserPointer(CpuAddr buffer, size_t size) NN_NOEXCEPT;
void WaitForUnmap() NN_NOEXCEPT;
void InvalidateDspCache(DspAddr address, size_t size) NN_NOEXCEPT;

void ProcessCleanup(nn::dd::ProcessHandle processHandle) NN_NOEXCEPT;
void SendCommandBuffer(int sessionId, DspAddr command, size_t size, int renderingCycleLimit, bool isNew, uint64_t clientId)  NN_NOEXCEPT;
void Wait() NN_NOEXCEPT;
void Signal() NN_NOEXCEPT;

void SessionSuspend(AppletVolumeManager::SessionType type, int index) NN_NOEXCEPT;
void SessionResume(AppletVolumeManager::SessionType type, int index) NN_NOEXCEPT;
void SetVolume(AppletVolumeManager::SessionType type, int index, float volume, uint32_t durationUsec) NN_NOEXCEPT;
void SetRecordVolume(AppletVolumeManager::SessionType type, int index, float volume, uint32_t durationUsec) NN_NOEXCEPT;

void Wake() NN_NOEXCEPT;
void Sleep() NN_NOEXCEPT;
void DumpMappedPointer() NN_NOEXCEPT;

int GetRemainCommandCount(int sessionId) NN_NOEXCEPT;
void ClearRemainCommandCount(int sessionId) NN_NOEXCEPT;
int64_t GetRenderingStartTick(int sessionId) NN_NOEXCEPT;

}}}  // namespace nn::audio::dsp
