﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "audio_Axfx2DelayLine.h"

namespace nn { namespace audio {

// Put this code here because of avoid a performance degression by preventing inline expansion. (SIGLO-77155)
f32 Axfx2AllPassTick(Axfx2DelayLine *allpass, Axfx2DelayLine *allpass2,  Axfx2DelayLine *outLine, f32 in)
{
    f32 temp;
    f32 out;
    f32 coef;

    coef = allpass->coef;
    temp = in - coef *  *(allpass->out); // Axfx2DelayNextOut(allpass);
    out = coef * temp + Axfx2DelayTick(allpass, temp);

    coef = allpass2->coef;
    temp = out - coef *  *(allpass2->out);
    out = coef * temp + Axfx2DelayTick(allpass2, temp);

    Axfx2DelayTickNoReturnVal(outLine, out);

    return out;
}

}} // nn::audio
