﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../audio_AuxTypes.h" // AuxInfoDsp

namespace nn {
namespace audio {
namespace dsp {

int32_t ReadAuxBufferDsp( AuxInfoDsp* pOutBuffer, uint64_t bufferAddr, uint32_t countMax, int32_t* pOutData, uint32_t count, uint32_t readOffset, uint32_t updateCount ) NN_NOEXCEPT;

int32_t WriteAuxBufferDsp( AuxInfoDsp* pOutBuffer, uint64_t bufferAddr, uint32_t countMax, const int32_t* pData, const uint32_t writeCount, const uint32_t writeOffset, const uint32_t updateCount ) NN_NOEXCEPT;

void ResetAuxBufferDsp(AuxInfoDsp* pOutAuxBuffer) NN_NOEXCEPT;


} // namespace dsp
} // namespace audio
} // namespace nn

