﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include "audio_BuildDefinition.h"

namespace nn { namespace audio { namespace common {

template <typename T> T* PrepareArray(void* addr, int count) NN_NOEXCEPT
{
    T* start = reinterpret_cast<T*>(addr);
    T* p = start;
    for (auto i = 0; i < count; ++i)
    {
        new(p) T();
        ++p;
    }
    return start;
}

template <typename T> T* PrepareArrayWithIndex(void* addr, int count) NN_NOEXCEPT
{
    T* start = reinterpret_cast<T*>(addr);
    T* p = start;
    for (auto i = 0; i < count; ++i)
    {
        new(p) T(i);
        ++p;
    }
    return start;
}

template <bool condition, class A, class B> struct SizeComp;
template <class A, class B> struct SizeComp<true, A, B>
{
    typedef A Result;
};
template <class A, class B> struct SizeComp<false, A, B>
{
    typedef B Result;
};

template <class Target, class ...Types> struct BiggestType
{
    typedef typename BiggestType<Types...>::Result RecursiveResult;
    typedef typename SizeComp< (sizeof(Target) > sizeof(RecursiveResult)), Target, RecursiveResult>::Result Result;
};
template <class Target> struct BiggestType<Target>
{
    typedef Target Result;
};

template <class Target, class ...Types> struct BiggestAlignType
{
    typedef typename BiggestAlignType<Types...>::Result RecursiveResult;
    typedef typename SizeComp< (NN_ALIGNOF(Target) > NN_ALIGNOF(RecursiveResult)), Target, RecursiveResult>::Result Result;
};
template <class Target> struct BiggestAlignType<Target>
{
    typedef Target Result;
};

inline uint32_t CreateMagic(const char* word) NN_NOEXCEPT
{
    return static_cast<uint32_t>(
        (static_cast<uint8_t>(word[0]) << 0) |
        (static_cast<uint8_t>(word[1]) << 8) |
        (static_cast<uint8_t>(word[2]) << 16) |
        (static_cast<uint8_t>(word[3]) << 24));
}

const uint16_t AudioOutInitializedMagic = 0xCAFE;
const uint16_t AudioInInitializedMagic = 0xBABE;

// NN_ALIGNOF(std::max_align_t) == 8 on Win, NN_ALIGNOF(std::max_align_t) == 16 clang
static const int InfoTypeFieldAlignSize = 16;
static const int AdspCacheLineSize = 32;
}}}  // namespace nn::audio::common

// TODO: looking for any way but constexpr.
#define NN_AUDIO_ALIGN_UP(size, align) (((size) + ((align) - 1)) & ~((align) - 1))

#define NN_AUDIO_INFOTYPE_FILED_ALIGN NN_ALIGNAS(16)

#if defined(NN_AUDIO_ENABLE_INFOTYPE_CHECK)
#define NN_AUDIO_INFOTYPE_CHECK(typename, size)                  \
NN_STATIC_ASSERT(sizeof(typename) % NN_ALIGNOF(typename) == 0);  \
NN_STATIC_ASSERT(sizeof(typename) == size);
#else
#define NN_AUDIO_INFOTYPE_CHECK(typename, size)
#endif

#if defined(NN_BUILD_CONFIG_ADDRESS_32)
#define NN_AUDIO_ADDRESS_SELECT(a32, a64) (a32)
#elif defined(NN_BUILD_CONFIG_ADDRESS_64)
#define NN_AUDIO_ADDRESS_SELECT(a32, a64) (a64)
#else
#error "Unsupported addressing mode"
#endif

#if NN_AUDIO_DSP_ADDR_SIZE == 4
#define NN_AUDIO_DSP_ADDRESS_SELECT(a32, a64) (a32)
#elif NN_AUDIO_DSP_ADDR_SIZE == 8
#define NN_AUDIO_DSP_ADDRESS_SELECT(a32, a64) (a64)
#else
#error "Unsupported addressing mode"
#endif

#if NN_AUDIO_DSP_ADDR_SIZE == 8
#define NN_AUDIO_ENABLE_IF_DSP_ADDRESS_64(statement) statement
#else
#define NN_AUDIO_ENABLE_IF_DSP_ADDRESS_64(statement)
#endif

#if NN_AUDIO_DSP_ADDR_SIZE == 4
#define NN_AUDIO_ENABLE_IF_DSP_ADDRESS_32(statement) statement
#else
#define NN_AUDIO_ENABLE_IF_DSP_ADDRESS_32(statement)
#endif

#if defined(_NX_AUDIO_DSP_)
#define NN_STATIC_ASSERT(condition) \
    static_assert(condition, "Static assertion failure: '" #condition "'")
#else
#include <nn/nn_SdkAssert.h>
#define NN_AUDIO_ALIGNAS_UAC_BUFFER NN_OS_ALIGNAS_THREAD_STACK
#endif
